/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots;

import au.com.origin.snapshots.exceptions.MissingSnapshotPropertiesKeyException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SnapshotProperties {
    INSTANCE;

    private static final Logger log;
    Properties snapshotProperties = new Properties();

    private SnapshotProperties() {
        try {
            InputStream in = SnapshotProperties.class.getResourceAsStream("/snapshot.properties");
            this.snapshotProperties.load(in);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getOrThrow(String key) {
        Object value = SnapshotProperties.INSTANCE.snapshotProperties.get(key);
        if (value == null) {
            throw new MissingSnapshotPropertiesKeyException(key);
        }
        return value.toString();
    }

    public static <T> T getInstance(String key) {
        String value = SnapshotProperties.getOrThrow(key);
        return SnapshotProperties.createInstance(value);
    }

    public static <T> List<T> getInstances(String key) {
        String value = SnapshotProperties.getOrThrow(key);
        return Arrays.stream(value.split(",")).map(String::trim).map(it -> SnapshotProperties.createInstance(it)).collect(Collectors.toList());
    }

    private static <T> T createInstance(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (T)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate class " + className, e);
        }
    }

    static {
        log = LoggerFactory.getLogger(SnapshotProperties.class);
    }
}

