/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots.junit5;

import au.com.origin.snapshots.Expect;
import au.com.origin.snapshots.SnapshotVerifier;
import au.com.origin.snapshots.config.PropertyResolvingSnapshotConfig;
import au.com.origin.snapshots.config.SnapshotConfig;
import au.com.origin.snapshots.config.SnapshotConfigInjector;
import au.com.origin.snapshots.exceptions.SnapshotMatchException;
import au.com.origin.snapshots.logging.LoggingHelper;
import au.com.origin.snapshots.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotExtension
implements AfterAllCallback,
BeforeAllCallback,
SnapshotConfigInjector,
ParameterResolver,
BeforeEachCallback {
    private static final Logger log = LoggerFactory.getLogger(SnapshotExtension.class);
    private SnapshotVerifier snapshotVerifier;

    public void beforeAll(ExtensionContext context) {
        boolean failOnOrphans = this.shouldFailOnOrphans(context);
        Class testClass = (Class)context.getTestClass().orElseThrow(() -> new SnapshotMatchException("Unable to locate Test class"));
        this.snapshotVerifier = new SnapshotVerifier(this.getSnapshotConfig(), testClass, failOnOrphans);
    }

    public void afterAll(ExtensionContext context) {
        this.snapshotVerifier.validateSnapshots();
    }

    @Override
    public SnapshotConfig getSnapshotConfig() {
        return new PropertyResolvingSnapshotConfig();
    }

    private boolean shouldFailOnOrphans(ExtensionContext context) {
        try {
            Field field = context.getClass().getSuperclass().getDeclaredField("testDescriptor");
            field.setAccessible(true);
            Object testDescriptor = field.get(context);
            if (testDescriptor instanceof ClassTestDescriptor) {
                ClassTestDescriptor classTestDescriptor = (ClassTestDescriptor)testDescriptor;
                return classTestDescriptor.getChildren().size() > 1;
            }
            if (testDescriptor instanceof ClassBasedTestDescriptor) {
                ClassBasedTestDescriptor classTestDescriptor = (ClassBasedTestDescriptor)testDescriptor;
                return classTestDescriptor.getChildren().size() > 1;
            }
        }
        catch (Exception e) {
            log.error("FAILED: (Java Snapshot Testing) Unable to get JUnit5 ClassTestDescriptor or ClassBasedTestDescriptor!\nEnsure you are using Junit5 >= 5.3.2\nThis may be due to JUnit5 changing their private api as we use reflection to access it\nLog a support ticket https://github.com/origin-energy/java-snapshot-testing/issues and supply your JUnit5 version\nSetting failOnOrphans=true as this is the safest option.This means that running a test alone (say from the IDE) will fail the snapshot, you need to run the entire class.", (Throwable)e);
        }
        return true;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        boolean supports;
        boolean bl = supports = parameterContext.getParameter().getType() == Expect.class;
        if (supports) {
            LoggingHelper.deprecatedV5(log, "Injecting 'Expect' via method a argument is no longer recommended. Consider using instance variable injection instead.");
        }
        return supports;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return new Expect(this.snapshotVerifier, (Method)extensionContext.getTestMethod().orElseThrow(() -> new RuntimeException("getTestMethod() is missing")));
    }

    public void beforeEach(ExtensionContext context) {
        if (context.getTestInstance().isPresent() && context.getTestMethod().isPresent()) {
            ReflectionUtils.findFieldByPredicate((Class)context.getTestClass().get(), field -> field.getType() == Expect.class).ifPresent(field -> {
                Expect expect = Expect.of(this.snapshotVerifier, (Method)context.getTestMethod().get());
                ReflectionUtils.makeAccessible(field);
                try {
                    field.set(context.getTestInstance().get(), expect);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }
}

