/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots.serializers.v1;

import au.com.origin.snapshots.Snapshot;
import au.com.origin.snapshots.SnapshotSerializerContext;
import au.com.origin.snapshots.serializers.SerializerType;
import au.com.origin.snapshots.serializers.SnapshotSerializer;
import au.com.origin.snapshots.serializers.v1.ToStringSnapshotSerializer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class Base64SnapshotSerializer
implements SnapshotSerializer {
    private static final ToStringSnapshotSerializer toStringSnapshotSerializer = new ToStringSnapshotSerializer();

    @Override
    public Snapshot apply(Object object, SnapshotSerializerContext gen) {
        if (object == null) {
            toStringSnapshotSerializer.apply((Object)"", gen);
        }
        byte[] bytes = object instanceof byte[] ? (byte[])object : object.toString().getBytes(StandardCharsets.UTF_8);
        String encoded = Base64.getEncoder().encodeToString(bytes);
        return toStringSnapshotSerializer.apply((Object)encoded, gen);
    }

    @Override
    public String getOutputFormat() {
        return SerializerType.BASE64.name();
    }
}

