/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.function.Predicate;

public final class ReflectionUtils {
    public static Optional<Field> findFieldByPredicate(Class<?> clazz, Predicate<Field> predicate) {
        Class<?> targetClass = clazz;
        do {
            Field[] fields;
            for (Field field : fields = targetClass.getDeclaredFields()) {
                if (!predicate.test(field)) continue;
                return Optional.of(field);
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return Optional.empty();
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    private ReflectionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

