/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.api;

import java.util.Comparator;
import shadow.org.assertj.core.api.AbstractAssert;
import shadow.org.assertj.core.internal.Booleans;
import shadow.org.assertj.core.util.VisibleForTesting;

public abstract class AbstractBooleanAssert<SELF extends AbstractBooleanAssert<SELF>>
extends AbstractAssert<SELF, Boolean> {
    @VisibleForTesting
    Booleans booleans = Booleans.instance();

    public AbstractBooleanAssert(Boolean actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isTrue() {
        return this.isEqualTo(true);
    }

    public SELF isFalse() {
        return this.isEqualTo(false);
    }

    public SELF isEqualTo(boolean expected) {
        this.booleans.assertEqual(this.info, (Boolean)this.actual, expected);
        return (SELF)((AbstractBooleanAssert)this.myself);
    }

    public SELF isNotEqualTo(boolean other) {
        this.booleans.assertNotEqual(this.info, (Boolean)this.actual, other);
        return (SELF)((AbstractBooleanAssert)this.myself);
    }

    @Override
    @Deprecated
    public final SELF usingComparator(Comparator<? super Boolean> customComparator) {
        return (SELF)this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @Deprecated
    public final SELF usingComparator(Comparator<? super Boolean> customComparator, String customComparatorDescription) {
        throw new UnsupportedOperationException("custom Comparator is not supported for Boolean comparison");
    }
}

