/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.api;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import shadow.org.assertj.core.api.AbstractAssert;
import shadow.org.assertj.core.api.AbstractThrowableAssert;
import shadow.org.assertj.core.api.AssertionInfo;
import shadow.org.assertj.core.api.AssertionsForClassTypes;
import shadow.org.assertj.core.error.ShouldBeEqual;
import shadow.org.assertj.core.error.ShouldMatch;
import shadow.org.assertj.core.error.future.ShouldBeCancelled;
import shadow.org.assertj.core.error.future.ShouldBeCompleted;
import shadow.org.assertj.core.error.future.ShouldBeCompletedExceptionally;
import shadow.org.assertj.core.error.future.ShouldBeDone;
import shadow.org.assertj.core.error.future.ShouldHaveFailed;
import shadow.org.assertj.core.error.future.ShouldNotBeCancelled;
import shadow.org.assertj.core.error.future.ShouldNotBeCompleted;
import shadow.org.assertj.core.error.future.ShouldNotBeCompletedExceptionally;
import shadow.org.assertj.core.error.future.ShouldNotBeDone;
import shadow.org.assertj.core.error.future.ShouldNotHaveFailed;
import shadow.org.assertj.core.internal.Failures;
import shadow.org.assertj.core.presentation.PredicateDescription;

public abstract class AbstractCompletableFutureAssert<SELF extends AbstractCompletableFutureAssert<SELF, RESULT>, RESULT>
extends AbstractAssert<SELF, CompletableFuture<RESULT>> {
    protected AbstractCompletableFutureAssert(CompletableFuture<RESULT> actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isDone() {
        this.isNotNull();
        if (!((CompletableFuture)this.actual).isDone()) {
            this.throwAssertionError(ShouldBeDone.shouldBeDone((Future)this.actual));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    public SELF isNotDone() {
        this.isNotNull();
        if (((CompletableFuture)this.actual).isDone()) {
            this.throwAssertionError(ShouldNotBeDone.shouldNotBeDone((Future)this.actual));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    public SELF isCompletedExceptionally() {
        this.isNotNull();
        if (!((CompletableFuture)this.actual).isCompletedExceptionally()) {
            this.throwAssertionError(ShouldBeCompletedExceptionally.shouldHaveCompletedExceptionally((CompletableFuture)this.actual));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    public SELF isNotCompletedExceptionally() {
        this.isNotNull();
        if (((CompletableFuture)this.actual).isCompletedExceptionally()) {
            this.throwAssertionError(ShouldNotBeCompletedExceptionally.shouldNotHaveCompletedExceptionally((CompletableFuture)this.actual));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    public SELF isCancelled() {
        this.isNotNull();
        if (!((CompletableFuture)this.actual).isCancelled()) {
            this.throwAssertionError(ShouldBeCancelled.shouldBeCancelled((Future)this.actual));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    public SELF isNotCancelled() {
        this.isNotNull();
        if (((CompletableFuture)this.actual).isCancelled()) {
            this.throwAssertionError(ShouldNotBeCancelled.shouldNotBeCancelled((Future)this.actual));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    public SELF isCompleted() {
        this.isNotNull();
        if (!((CompletableFuture)this.actual).isDone() || ((CompletableFuture)this.actual).isCompletedExceptionally()) {
            this.throwAssertionError(ShouldBeCompleted.shouldBeCompleted((CompletableFuture)this.actual));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    public SELF isNotCompleted() {
        this.isNotNull();
        if (((CompletableFuture)this.actual).isDone() && !((CompletableFuture)this.actual).isCompletedExceptionally()) {
            this.throwAssertionError(ShouldNotBeCompleted.shouldNotBeCompleted((CompletableFuture)this.actual));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    public SELF isCompletedWithValue(RESULT expected) {
        this.isCompleted();
        Object actualResult = ((CompletableFuture)this.actual).join();
        if (!Objects.equals(actualResult, expected)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqual.shouldBeEqual(actualResult, expected, this.info.representation()));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    public SELF isCompletedWithValueMatching(Predicate<? super RESULT> predicate) {
        return this.isCompletedWithValueMatching(predicate, PredicateDescription.GIVEN);
    }

    public SELF isCompletedWithValueMatching(Predicate<? super RESULT> predicate, String description) {
        return this.isCompletedWithValueMatching(predicate, new PredicateDescription(description));
    }

    private SELF isCompletedWithValueMatching(Predicate<? super RESULT> predicate, PredicateDescription description) {
        this.isCompleted();
        Object actualResult = ((CompletableFuture)this.actual).join();
        if (!predicate.test(actualResult)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldMatch.shouldMatch(actualResult, predicate, description));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    public SELF hasFailed() {
        this.isNotNull();
        if (!((CompletableFuture)this.actual).isCompletedExceptionally() || ((CompletableFuture)this.actual).isCancelled()) {
            this.throwAssertionError(ShouldHaveFailed.shouldHaveFailed((CompletableFuture)this.actual));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    public SELF hasNotFailed() {
        this.isNotNull();
        if (((CompletableFuture)this.actual).isCompletedExceptionally() && !((CompletableFuture)this.actual).isCancelled()) {
            this.throwAssertionError(ShouldNotHaveFailed.shouldNotHaveFailed((CompletableFuture)this.actual));
        }
        return (SELF)((AbstractCompletableFutureAssert)this.myself);
    }

    public AbstractThrowableAssert<?, ? extends Throwable> hasFailedWithThrowableThat() {
        this.hasFailed();
        try {
            ((CompletableFuture)this.actual).join();
            return AssertionsForClassTypes.assertThat((Throwable)null);
        }
        catch (CompletionException e) {
            return AssertionsForClassTypes.assertThat(e.getCause());
        }
    }
}

