/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.api;

import java.util.OptionalInt;
import shadow.org.assertj.core.api.AbstractAssert;
import shadow.org.assertj.core.error.OptionalShouldBeEmpty;
import shadow.org.assertj.core.error.OptionalShouldBePresent;
import shadow.org.assertj.core.error.OptionalShouldContain;
import shadow.org.assertj.core.internal.Integers;
import shadow.org.assertj.core.util.VisibleForTesting;

public abstract class AbstractOptionalIntAssert<SELF extends AbstractOptionalIntAssert<SELF>>
extends AbstractAssert<SELF, OptionalInt> {
    @VisibleForTesting
    Integers integers = Integers.instance();

    protected AbstractOptionalIntAssert(OptionalInt actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isPresent() {
        this.isNotNull();
        if (!((OptionalInt)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldBePresent.shouldBePresent(this.actual));
        }
        return (SELF)((AbstractOptionalIntAssert)this.myself);
    }

    public SELF isNotPresent() {
        return this.isEmpty();
    }

    public SELF isEmpty() {
        this.isNotNull();
        if (((OptionalInt)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldBeEmpty.shouldBeEmpty((OptionalInt)this.actual));
        }
        return (SELF)((AbstractOptionalIntAssert)this.myself);
    }

    public SELF isNotEmpty() {
        return this.isPresent();
    }

    public SELF hasValue(int expectedValue) {
        this.isNotNull();
        if (!((OptionalInt)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldContain.shouldContain(expectedValue));
        }
        if (expectedValue != ((OptionalInt)this.actual).getAsInt()) {
            this.throwAssertionError(OptionalShouldContain.shouldContain((OptionalInt)this.actual, expectedValue));
        }
        return (SELF)((AbstractOptionalIntAssert)this.myself);
    }
}

