/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.api;

import java.util.function.Predicate;
import shadow.org.assertj.core.api.AbstractAssert;
import shadow.org.assertj.core.error.ShouldAccept;
import shadow.org.assertj.core.error.ShouldNotAccept;
import shadow.org.assertj.core.internal.Iterables;
import shadow.org.assertj.core.presentation.PredicateDescription;
import shadow.org.assertj.core.util.VisibleForTesting;

abstract class AbstractPredicateLikeAssert<SELF extends AbstractPredicateLikeAssert<SELF, PRIMITIVE_PREDICATE, PRIMITIVE>, PRIMITIVE_PREDICATE, PRIMITIVE>
extends AbstractAssert<SELF, PRIMITIVE_PREDICATE> {
    @VisibleForTesting
    Iterables iterables = Iterables.instance();
    @VisibleForTesting
    Predicate<PRIMITIVE> primitivePredicate;

    protected AbstractPredicateLikeAssert(PRIMITIVE_PREDICATE actual, Predicate<PRIMITIVE> wrappedPredicate, Class<?> selfType) {
        super(actual, selfType);
        this.primitivePredicate = wrappedPredicate;
    }

    protected SELF acceptsInternal(PRIMITIVE value) {
        this.isNotNull();
        if (!this.primitivePredicate.test(value)) {
            this.throwAssertionError(ShouldAccept.shouldAccept(this.primitivePredicate, value, PredicateDescription.GIVEN));
        }
        return (SELF)((AbstractPredicateLikeAssert)this.myself);
    }

    protected SELF rejectsInternal(PRIMITIVE value) {
        this.isNotNull();
        if (this.primitivePredicate.test(value)) {
            this.throwAssertionError(ShouldNotAccept.shouldNotAccept(this.primitivePredicate, value, PredicateDescription.GIVEN));
        }
        return (SELF)((AbstractPredicateLikeAssert)this.myself);
    }

    protected SELF acceptsAllInternal(Iterable<? extends PRIMITIVE> values) {
        this.isNotNull();
        this.iterables.assertAllMatch(this.info, values, this.primitivePredicate, PredicateDescription.GIVEN);
        return (SELF)((AbstractPredicateLikeAssert)this.myself);
    }

    protected SELF rejectsAllInternal(Iterable<? extends PRIMITIVE> values) {
        this.isNotNull();
        this.iterables.assertNoneMatch(this.info, values, this.primitivePredicate, PredicateDescription.GIVEN);
        return (SELF)((AbstractPredicateLikeAssert)this.myself);
    }
}

