/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.api;

import java.util.Objects;
import shadow.org.assertj.core.api.AbstractAssert;
import shadow.org.assertj.core.api.AbstractObjectAssert;
import shadow.org.assertj.core.api.AbstractThrowableAssert;
import shadow.org.assertj.core.api.Assertions;
import shadow.org.assertj.core.api.Descriptable;
import shadow.org.assertj.core.api.ThrowableAssert;
import shadow.org.assertj.core.api.ThrowableAssertAlternative;
import shadow.org.assertj.core.description.Description;
import shadow.org.assertj.core.description.TextDescription;
import shadow.org.assertj.core.util.CheckReturnValue;
import shadow.org.assertj.core.util.VisibleForTesting;

public class ThrowableTypeAssert<T extends Throwable>
implements Descriptable<ThrowableTypeAssert<T>> {
    @VisibleForTesting
    protected final Class<? extends T> expectedThrowableType;
    protected Description description;

    public ThrowableTypeAssert(Class<? extends T> throwableType) {
        this.expectedThrowableType = Objects.requireNonNull(throwableType, "exceptionType");
    }

    public ThrowableAssertAlternative<T> isThrownBy(ThrowableAssert.ThrowingCallable throwingCallable) {
        Throwable throwable = ThrowableAssert.catchThrowable(throwingCallable);
        ((AbstractAssert)((AbstractThrowableAssert)((AbstractObjectAssert)((Object)Assertions.assertThat(throwable))).as(this.description)).hasBeenThrown()).isInstanceOf((Class)this.expectedThrowableType);
        Throwable c = throwable;
        return (ThrowableAssertAlternative)new ThrowableAssertAlternative<Throwable>(c).as(this.description);
    }

    @Override
    @CheckReturnValue
    public ThrowableTypeAssert<T> as(String description, Object ... args) {
        return this.describedAs(description, args);
    }

    @Override
    @CheckReturnValue
    public ThrowableTypeAssert<T> as(Description description) {
        return this.describedAs(description);
    }

    @Override
    @CheckReturnValue
    public ThrowableTypeAssert<T> describedAs(String description, Object ... args) {
        this.description = new TextDescription(description, args);
        return this;
    }

    @Override
    @CheckReturnValue
    public ThrowableTypeAssert<T> describedAs(Description description) {
        this.description = description;
        return this;
    }
}

