/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.error;

import shadow.org.assertj.core.error.BasicErrorMessageFactory;
import shadow.org.assertj.core.error.ErrorMessageFactory;
import shadow.org.assertj.core.internal.ComparisonStrategy;
import shadow.org.assertj.core.internal.StandardComparisonStrategy;
import shadow.org.assertj.core.util.IterableUtil;

public class ShouldContainExactly
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldContainExactly(Object actual, Iterable<?> expected, Iterable<?> notFound, Iterable<?> notExpected, ComparisonStrategy comparisonStrategy) {
        if (IterableUtil.isNullOrEmpty(notExpected)) {
            return new ShouldContainExactly(actual, expected, notFound, comparisonStrategy);
        }
        if (IterableUtil.isNullOrEmpty(notFound)) {
            return new ShouldContainExactly(actual, expected, comparisonStrategy, notExpected);
        }
        return new ShouldContainExactly(actual, expected, notFound, notExpected, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldContainExactly(Object actual, Iterable<?> expected, Iterable<?> notFound, Iterable<?> notExpected) {
        return ShouldContainExactly.shouldContainExactly(actual, expected, notFound, notExpected, StandardComparisonStrategy.instance());
    }

    private ShouldContainExactly(Object actual, Object expected, Object notFound, Object notExpected, ComparisonStrategy comparisonStrategy) {
        super("%nExpecting:%n  <%s>%nto contain exactly (and in same order):%n  <%s>%nbut some elements were not found:%n  <%s>%nand others were not expected:%n  <%s>%n%s", actual, expected, notFound, notExpected, comparisonStrategy);
    }

    private ShouldContainExactly(Object actual, Object expected, Object notFound, ComparisonStrategy comparisonStrategy) {
        super("%nExpecting:%n  <%s>%nto contain exactly (and in same order):%n  <%s>%nbut could not find the following elements:%n  <%s>%n%s", actual, expected, notFound, comparisonStrategy);
    }

    private ShouldContainExactly(Object actual, Object expected, ComparisonStrategy comparisonStrategy, Object unexpected) {
        super("%nExpecting:%n  <%s>%nto contain exactly (and in same order):%n  <%s>%nbut some elements were not expected:%n  <%s>%n%s", actual, expected, unexpected, comparisonStrategy);
    }

    public static ErrorMessageFactory elementsDifferAtIndex(Object actualElement, Object expectedElement, int indexOfDifferentElements, ComparisonStrategy comparisonStrategy) {
        return new ShouldContainExactly(actualElement, expectedElement, indexOfDifferentElements, comparisonStrategy);
    }

    public static ErrorMessageFactory elementsDifferAtIndex(Object actualElement, Object expectedElement, int indexOfDifferentElements) {
        return new ShouldContainExactly(actualElement, expectedElement, indexOfDifferentElements, (ComparisonStrategy)StandardComparisonStrategy.instance());
    }

    private ShouldContainExactly(Object actualElement, Object expectedElement, int indexOfDifferentElements, ComparisonStrategy comparisonStrategy) {
        super("%nActual and expected have the same elements but not in the same order, at index %s actual element was:%n  <%s>%nwhereas expected element was:%n  <%s>%n%s", indexOfDifferentElements, actualElement, expectedElement, comparisonStrategy);
    }
}

