/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.error;

import java.util.Set;
import shadow.org.assertj.core.error.BasicErrorMessageFactory;
import shadow.org.assertj.core.error.ErrorMessageFactory;
import shadow.org.assertj.core.internal.ComparisonStrategy;
import shadow.org.assertj.core.internal.StandardComparisonStrategy;
import shadow.org.assertj.core.util.IterableUtil;

public class ShouldContainsOnlyOnce
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldContainsOnlyOnce(Object actual, Object expected, Set<?> notFound, Set<?> notOnlyOnce, ComparisonStrategy comparisonStrategy) {
        if (!IterableUtil.isNullOrEmpty(notFound) && !IterableUtil.isNullOrEmpty(notOnlyOnce)) {
            return new ShouldContainsOnlyOnce(actual, expected, notFound, notOnlyOnce, comparisonStrategy);
        }
        if (!IterableUtil.isNullOrEmpty(notFound)) {
            return new ShouldContainsOnlyOnce(actual, expected, notFound, comparisonStrategy);
        }
        return new ShouldContainsOnlyOnce(notOnlyOnce, actual, expected, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldContainsOnlyOnce(Object actual, Object expected, Set<?> notFound, Set<?> notOnlyOnce) {
        return ShouldContainsOnlyOnce.shouldContainsOnlyOnce(actual, expected, notFound, notOnlyOnce, StandardComparisonStrategy.instance());
    }

    private ShouldContainsOnlyOnce(Object actual, Object expected, Set<?> notFound, Set<?> notOnlyOnce, ComparisonStrategy comparisonStrategy) {
        super("%nExpecting:%n <%s>%nto contain only once:%n <%s>%nbut some elements were not found:%n <%s>%nand others were found more than once:%n <%s>%n%s", actual, expected, notFound, notOnlyOnce, comparisonStrategy);
    }

    private ShouldContainsOnlyOnce(Object actual, Object expected, Set<?> notFound, ComparisonStrategy comparisonStrategy) {
        super("%nExpecting:%n <%s>%nto contain only once:%n <%s>%nbut some elements were not found:%n <%s>%n%s", actual, expected, notFound, comparisonStrategy);
    }

    private ShouldContainsOnlyOnce(Set<?> notOnlyOnce, Object actual, Object expected, ComparisonStrategy comparisonStrategy) {
        super("%nExpecting:%n <%s>%nto contain only once:%n <%s>%nbut some elements were found more than once:%n <%s>%n%s", actual, expected, notOnlyOnce, comparisonStrategy);
    }
}

