/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.error;

import shadow.org.assertj.core.configuration.ConfigurationProvider;
import shadow.org.assertj.core.error.BasicErrorMessageFactory;

public class ShouldOnlyHaveElementsOfTypes
extends BasicErrorMessageFactory {
    public static ShouldOnlyHaveElementsOfTypes shouldOnlyHaveElementsOfTypes(Object actual, Class<?>[] types, Iterable<?> dismatches) {
        return new ShouldOnlyHaveElementsOfTypes(actual, types, dismatches);
    }

    private ShouldOnlyHaveElementsOfTypes(Object actual, Class<?>[] types, Iterable<?> nonMatchingElements) {
        super("%nExpecting:%n  <%s>%nto only have instances of:%n  <%s>%nbut these elements are not:%n  <[" + ShouldOnlyHaveElementsOfTypes.resolveClassNames(nonMatchingElements) + "]>", actual, types);
    }

    private static String resolveClassNames(Iterable<?> elements) {
        StringBuilder builder = new StringBuilder();
        for (Object element : elements) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            String formatted = ConfigurationProvider.CONFIGURATION_PROVIDER.representation().toStringOf(element);
            builder.append(formatted);
            if (element == null || formatted.contains(element.getClass().getName())) continue;
            builder.append(" (").append(element.getClass().getName()).append(")");
        }
        return builder.toString();
    }
}

