/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.error;

import java.util.List;
import java.util.stream.Collectors;
import shadow.org.assertj.core.error.BasicErrorMessageFactory;
import shadow.org.assertj.core.error.ErrorMessageFactory;

public class ZippedElementsShouldSatisfy
extends BasicErrorMessageFactory {
    private static final String DELIMITER = String.format("%n%n- ", new Object[0]);

    public static ErrorMessageFactory zippedElementsShouldSatisfy(Object actual, Object other, List<ZipSatisfyError> zipSatisfyErrors) {
        return new ZippedElementsShouldSatisfy(actual, other, zipSatisfyErrors);
    }

    private ZippedElementsShouldSatisfy(Object actual, Object other, List<ZipSatisfyError> zipSatisfyErrors) {
        super("%nExpecting zipped elements of:%n  <%s>%nand:%n  <%s>%nto satisfy given requirements but these zipped elements did not:" + ZippedElementsShouldSatisfy.describe(zipSatisfyErrors), actual, other);
    }

    private static String describe(List<ZipSatisfyError> zipSatisfyErrors) {
        List errorsToStrings = zipSatisfyErrors.stream().map(ZipSatisfyError::toString).collect(Collectors.toList());
        return DELIMITER + String.join((CharSequence)DELIMITER, errorsToStrings);
    }

    public static class ZipSatisfyError {
        public final Object actualElement;
        public final Object otherElement;
        public final String error;

        public ZipSatisfyError(Object actualElement, Object otherElement, String error) {
            this.actualElement = actualElement;
            this.otherElement = otherElement;
            this.error = error;
        }

        public String toString() {
            return String.format("(%s, %s) error: %s", this.actualElement, this.otherElement, this.error);
        }
    }
}

