/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.extractor;

import java.util.stream.Stream;
import shadow.org.assertj.core.api.iterable.Extractor;
import shadow.org.assertj.core.extractor.ByNameMultipleExtractor;
import shadow.org.assertj.core.extractor.ByNameSingleExtractor;
import shadow.org.assertj.core.extractor.ResultOfExtractor;
import shadow.org.assertj.core.extractor.ToStringExtractor;
import shadow.org.assertj.core.groups.Tuple;
import shadow.org.assertj.core.util.Strings;

public class Extractors {
    public static Extractor<Object, String> toStringMethod() {
        return new ToStringExtractor();
    }

    public static <F> Extractor<F, Object> byName(String fieldOrProperty) {
        return new ByNameSingleExtractor(fieldOrProperty);
    }

    public static <F> Extractor<F, Tuple> byName(String ... fieldsOrProperties) {
        return new ByNameMultipleExtractor(fieldsOrProperties);
    }

    public static <F> Extractor<F, Object> resultOf(String methodName) {
        return new ResultOfExtractor(methodName);
    }

    public static String extractedDescriptionOf(String ... itemsDescription) {
        return String.format("Extracted: %s", Strings.join(itemsDescription).with(", "));
    }

    public static String extractedDescriptionOf(Object ... items) {
        String[] itemsDescription = (String[])Stream.of(items).map(Object::toString).toArray(String[]::new);
        return Extractors.extractedDescriptionOf(itemsDescription);
    }

    public static String extractedDescriptionOfMethod(String method) {
        return String.format("Extracted: result of %s()", method);
    }
}

