/*
 * Decompiled with CFR 0.152.
 */
package io.mashona.logwriting;

import io.mashona.logwriting.ArrayStore;
import io.mashona.logwriting.PersistenceHandle;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.CRC32C;
import jdk.nio.mapmode.ExtendedMapMode;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import sun.misc.Unsafe;

public class ArrayStoreImpl
implements ArrayStore {
    private static final XLogger logger = XLoggerFactory.getXLogger(ArrayStoreImpl.class);
    private static Unsafe unsafe;
    private static final int BLOCK_SIZE = 256;
    private static final int RECORD_METADATA_SIZE = 8;
    private static final byte[] ZERO_ARRAY;
    private final File file;
    private final int numberOfSlots;
    private final int slotDataCapacity;
    private final int slotSize;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final FileChannel fileChannel;
    private final MappedByteBuffer dataBuffer;
    private final PersistenceHandle persistenceHandle;

    public ArrayStoreImpl(File file, int numberOfSlots, int slotDataCapacity) throws IOException {
        logger.entry(new Object[]{file, numberOfSlots, slotDataCapacity});
        this.file = file;
        this.numberOfSlots = numberOfSlots;
        this.slotDataCapacity = slotDataCapacity;
        this.slotSize = this.calculateSlotSize(slotDataCapacity);
        int length = numberOfSlots * this.slotSize;
        this.fileChannel = (FileChannel)Files.newByteChannel(file.toPath(), EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE), new FileAttribute[0]);
        this.dataBuffer = this.fileChannel.map(ExtendedMapMode.READ_WRITE_SYNC, 0L, length);
        this.persistenceHandle = new PersistenceHandle(this.dataBuffer, 0, length);
        logger.exit();
    }

    public int getNumberOfSlots() {
        return this.numberOfSlots;
    }

    public int getSlotDataCapacity() {
        return this.slotDataCapacity;
    }

    @Override
    public void close() throws IOException {
        logger.entry(new Object[0]);
        this.lock.writeLock().lock();
        try {
            unsafe.invokeCleaner(this.dataBuffer);
            this.fileChannel.close();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        logger.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int slotIndex, ByteBuffer src, boolean force) throws IOException {
        logger.entry(new Object[]{this, slotIndex, src, force});
        this.validateIndex(slotIndex);
        this.lock.readLock().lock();
        try {
            this.validateIsOpen();
            int dataSize = src.remaining();
            if (dataSize > this.slotDataCapacity) {
                IOException e = new IOException("data of size " + dataSize + " too big for slot of size " + this.slotDataCapacity);
                logger.throwing((Throwable)e);
                throw e;
            }
            int position = slotIndex * this.slotSize;
            ByteBuffer srcSlice = src.duplicate().position(src.position()).limit(src.position() + dataSize).duplicate();
            ByteBuffer dst = this.dataBuffer.duplicate().position(position).limit(position + this.slotSize).duplicate();
            CRC32C crc32c = new CRC32C();
            crc32c.update(srcSlice);
            int checksum = (int)crc32c.getValue();
            srcSlice.rewind();
            dst.putInt(dataSize);
            dst.putInt(checksum);
            dst.put(srcSlice);
            if (force) {
                this.persistenceHandle.persist(position, dataSize + 8);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        logger.exit();
    }

    @Override
    public void write(int slotIndex, byte[] data, boolean force) throws IOException {
        this.write(slotIndex, ByteBuffer.wrap(data), force);
    }

    @Override
    public ByteBuffer readAsByteBuffer(int slotIndex) throws IOException {
        byte[] data = this.readAsByteArray(slotIndex);
        if (data != null) {
            return ByteBuffer.wrap(data);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readAsByteArray(int slotIndex) throws IOException {
        logger.entry(new Object[]{slotIndex});
        this.validateIndex(slotIndex);
        byte[] result = null;
        this.lock.readLock().lock();
        try {
            this.validateIsOpen();
            int position = slotIndex * this.slotSize;
            ByteBuffer recordBuffer = this.dataBuffer.duplicate();
            recordBuffer.position(position);
            int payloadLength = recordBuffer.getInt();
            if (payloadLength == 0) {
                byte[] byArray = null;
                return byArray;
            }
            int expectedChecksum = recordBuffer.getInt();
            ByteBuffer payloadBuffer = recordBuffer.slice();
            payloadBuffer.limit(payloadLength);
            recordBuffer.position(recordBuffer.position() + payloadLength);
            CRC32C crc32c = new CRC32C();
            crc32c.reset();
            crc32c.update(payloadBuffer);
            int actualChecksum = (int)crc32c.getValue();
            payloadBuffer.rewind();
            if (actualChecksum == expectedChecksum) {
                result = new byte[payloadLength];
                payloadBuffer.get(result);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        logger.exit((Object)result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(int slotIndex, boolean scrub, boolean force) throws IOException {
        logger.entry(new Object[]{this, slotIndex, scrub, force});
        this.lock.readLock().lock();
        try {
            this.validateIsOpen();
            if (scrub) {
                byte[] data = new byte[this.slotDataCapacity];
                this.write(slotIndex, data, true);
            }
            this.write(slotIndex, ZERO_ARRAY, force);
        }
        finally {
            this.lock.readLock().unlock();
        }
        logger.exit();
    }

    private void validateIndex(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= this.numberOfSlots) {
            ArrayIndexOutOfBoundsException e = new ArrayIndexOutOfBoundsException(slotIndex);
            logger.throwing((Throwable)e);
            throw e;
        }
    }

    private void validateIsOpen() throws ClosedChannelException {
        if (!this.fileChannel.isOpen()) {
            ClosedChannelException closedChannelException = new ClosedChannelException();
            logger.throwing((Throwable)closedChannelException);
            throw closedChannelException;
        }
    }

    private int calculateSlotSize(int slotDataCapacity) {
        int remainder = (slotDataCapacity += 8) % 256;
        if (remainder == 0) {
            return slotDataCapacity;
        }
        return slotDataCapacity + 256 - remainder;
    }

    static {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            unsafe = (Unsafe)f.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ZERO_ARRAY = new byte[0];
    }
}

