/*
 * Decompiled with CFR 0.152.
 */
package io.mashona.logwriting;

import java.lang.reflect.Field;
import java.nio.MappedByteBuffer;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public class PersistenceHandle {
    private static final XLogger logger = XLoggerFactory.getXLogger(PersistenceHandle.class);
    private static Field fdField;
    private final MappedByteBuffer buffer;
    private final int offset;
    private final int length;

    public static void setParanoid(boolean value) throws Exception {
        logger.entry(new Object[]{value});
        if (value) {
            fdField = MappedByteBuffer.class.getDeclaredField("fd");
            fdField.setAccessible(true);
        } else {
            fdField = null;
        }
        logger.exit();
    }

    public PersistenceHandle(MappedByteBuffer buffer, int offset, int length) {
        logger.entry(new Object[]{buffer, offset, length});
        this.validateBuffer(buffer);
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
        logger.exit((Object)this);
    }

    private void validateBuffer(MappedByteBuffer buff) {
        if (fdField != null) {
            boolean ok = true;
            try {
                ok = fdField.get(buff) != null;
            }
            catch (Exception e) {
                logger.debug("Exception whilst trying to validate handle for {}. Continuing anyhow.", (Object)buff, (Object)e);
            }
            if (!ok) {
                IllegalArgumentException exception = new IllegalArgumentException("Persistence would be ineffective on " + buff);
                logger.throwing((Throwable)exception);
                throw exception;
            }
        }
    }

    PersistenceHandle duplicate(int offset, int length) {
        logger.entry(new Object[]{offset, length});
        if (length > this.length) {
            throw new IllegalArgumentException("given length of " + length + " exceeds max of " + this.length);
        }
        PersistenceHandle persistenceHandle = new PersistenceHandle(this.buffer, this.offset + offset, length);
        logger.exit((Object)persistenceHandle);
        return persistenceHandle;
    }

    public void persist(int from, int length) {
        logger.entry(new Object[]{this, from, length});
        if (length > this.length) {
            throw new IllegalArgumentException("given length of " + length + " exceeds max of " + this.length);
        }
        this.buffer.force(from + this.offset, length);
        logger.exit();
    }

    public void persist() {
        logger.entry(new Object[]{this});
        this.persist(0, this.length);
        logger.exit();
    }

    static {
        try {
            PersistenceHandle.setParanoid(Boolean.getBoolean("persistent.paranoia"));
        }
        catch (Exception e) {
            logger.debug("Exception whilst configuring persistent handle validation. Validation will be disabled.", (Throwable)e);
            fdField = null;
        }
    }
}

