/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.async;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import io.micrometer.spring.async.ThreadPoolTaskExecutorMetrics;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.concurrent.ListenableFuture;

@NonNullApi
@NonNullFields
public class TimedThreadPoolTaskExecutor
extends ThreadPoolTaskExecutor {
    private final MeterRegistry registry;
    private final String name;
    private final Iterable<Tag> tags;
    private final Timer timer;

    public TimedThreadPoolTaskExecutor(MeterRegistry registry, String name, Iterable<Tag> tags) {
        this.registry = registry;
        this.name = name;
        this.tags = tags;
        this.timer = registry.timer(name, tags);
    }

    public void initialize() {
        super.initialize();
        new ThreadPoolTaskExecutorMetrics(this, this.name, this.tags).bindTo(this.registry);
    }

    public void execute(Runnable task) {
        super.execute(this.timer.wrap(task));
    }

    public void execute(Runnable task, long startTimeout) {
        super.execute(this.timer.wrap(task), startTimeout);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return super.submit(this.timer.wrap(task));
    }

    public Future<?> submit(Runnable task) {
        return super.submit(this.timer.wrap(task));
    }

    public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
        return super.submitListenable(this.timer.wrap(task));
    }

    public ListenableFuture<?> submitListenable(Runnable task) {
        return super.submitListenable(this.timer.wrap(task));
    }
}

