/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.cache;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.spring.cache.CacheMeterBinderProvider;
import io.micrometer.spring.cache.CacheMetricsRegistrar;
import java.util.Collection;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.util.StringUtils;

@Configuration
@Conditional(value={CacheMetricsRegistrarConditionalOnBeans.class})
class CacheMetricsRegistrarConfiguration {
    private static final String CACHE_MANAGER_SUFFIX = "cacheManager";
    private final MeterRegistry registry;
    private final CacheMetricsRegistrar cacheMetricsRegistrar;
    private final Map<String, CacheManager> cacheManagers;

    CacheMetricsRegistrarConfiguration(MeterRegistry registry, Collection<CacheMeterBinderProvider<?>> binderProviders, Map<String, CacheManager> cacheManagers) {
        this.registry = registry;
        this.cacheManagers = cacheManagers;
        this.cacheMetricsRegistrar = new CacheMetricsRegistrar(this.registry, binderProviders);
    }

    @Bean
    public CacheMetricsRegistrar cacheMetricsRegistrar() {
        return this.cacheMetricsRegistrar;
    }

    @PostConstruct
    public void bindCachesToRegistry() {
        this.cacheManagers.forEach(this::bindCacheManagerToRegistry);
    }

    private void bindCacheManagerToRegistry(String beanName, CacheManager cacheManager) {
        cacheManager.getCacheNames().forEach(cacheName -> this.bindCacheToRegistry(beanName, cacheManager.getCache(cacheName)));
    }

    private void bindCacheToRegistry(String beanName, Cache cache) {
        Tag cacheManagerTag = Tag.of((String)CACHE_MANAGER_SUFFIX, (String)this.getCacheManagerName(beanName));
        this.cacheMetricsRegistrar.bindCacheToRegistry(cache, cacheManagerTag);
    }

    private String getCacheManagerName(String beanName) {
        if (beanName.length() > CACHE_MANAGER_SUFFIX.length() && StringUtils.endsWithIgnoreCase((String)beanName, (String)CACHE_MANAGER_SUFFIX)) {
            return beanName.substring(0, beanName.length() - CACHE_MANAGER_SUFFIX.length());
        }
        return beanName;
    }

    static class CacheMetricsRegistrarConditionalOnBeans
    extends AllNestedConditions {
        CacheMetricsRegistrarConditionalOnBeans() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={CacheMeterBinderProvider.class})
        static class ConditionalOnCacheMeterBinderProviderBean {
            ConditionalOnCacheMeterBinderProviderBean() {
            }
        }

        @ConditionalOnBean(value={MeterRegistry.class})
        static class ConditionalOnMeterRegistryBean {
            ConditionalOnMeterRegistryBean() {
            }
        }
    }
}

