/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.jmx;

import io.micrometer.core.instrument.Clock;
import io.micrometer.jmx.JmxConfig;
import io.micrometer.jmx.JmxMeterRegistry;
import io.micrometer.spring.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import io.micrometer.spring.autoconfigure.export.StringToDurationConverter;
import io.micrometer.spring.autoconfigure.export.jmx.JmxProperties;
import io.micrometer.spring.autoconfigure.export.jmx.JmxPropertiesConfigAdapter;
import io.micrometer.spring.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={JmxMeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.jmx", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={JmxProperties.class})
@Import(value={StringToDurationConverter.class})
public class JmxMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public JmxConfig jmxConfig(JmxProperties props) {
        return new JmxPropertiesConfigAdapter(props);
    }

    @Bean
    @ConditionalOnMissingBean
    public JmxMeterRegistry jmxMeterRegistry(JmxConfig config, Clock clock) {
        return new JmxMeterRegistry(config, clock);
    }
}

