/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.web.servlet;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import io.micrometer.spring.autoconfigure.MetricsProperties;
import io.micrometer.spring.autoconfigure.OnlyOnceLoggingDenyMeterFilter;
import io.micrometer.spring.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import io.micrometer.spring.web.servlet.DefaultWebMvcTagsProvider;
import io.micrometer.spring.web.servlet.WebMvcMetricsFilter;
import io.micrometer.spring.web.servlet.WebMvcTagsProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnWebApplication
@ConditionalOnClass(value={DispatcherServlet.class})
@ConditionalOnBean(value={MeterRegistry.class})
@EnableConfigurationProperties(value={MetricsProperties.class})
public class WebMvcMetricsAutoConfiguration {
    private final MetricsProperties properties;

    public WebMvcMetricsAutoConfiguration(MetricsProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={WebMvcTagsProvider.class})
    public DefaultWebMvcTagsProvider servletTagsProvider() {
        return new DefaultWebMvcTagsProvider();
    }

    @Bean
    public WebMvcMetricsFilter webMetricsFilter(MeterRegistry registry, WebMvcTagsProvider tagsProvider, WebApplicationContext ctx) {
        return new WebMvcMetricsFilter(registry, tagsProvider, this.properties.getWeb().getServer().getRequestsMetricName(), this.properties.getWeb().getServer().isAutoTimeRequests(), new HandlerMappingIntrospector((ApplicationContext)ctx));
    }

    @Bean
    @Order(value=0)
    public MeterFilter metricsHttpServerUriTagFilter() {
        String metricName = this.properties.getWeb().getServer().getRequestsMetricName();
        OnlyOnceLoggingDenyMeterFilter filter = new OnlyOnceLoggingDenyMeterFilter(() -> String.format("Reached the maximum number of URI tags for '%s'.", metricName));
        return MeterFilter.maximumAllowableTags((String)metricName, (String)"uri", (int)this.properties.getWeb().getServer().getMaxUriTags(), (MeterFilter)filter);
    }
}

