/*
 * Decompiled with CFR 0.152.
 */
package io.milton.dns.record;

import io.milton.dns.Name;
import io.milton.dns.record.Compression;
import io.milton.dns.record.DNSInput;
import io.milton.dns.record.DNSOutput;
import io.milton.dns.record.DNSSEC;
import io.milton.dns.record.Mnemonic;
import io.milton.dns.record.Options;
import io.milton.dns.record.Record;
import io.milton.dns.record.Tokenizer;
import io.milton.dns.utils.base64;
import java.io.IOException;

public class CERTRecord
extends Record {
    public static final int PKIX = 1;
    public static final int SPKI = 2;
    public static final int PGP = 3;
    public static final int URI = 253;
    public static final int OID = 254;
    private static final long serialVersionUID = 4763014646517016835L;
    private int certType;
    private int keyTag;
    private int alg;
    private byte[] cert;

    CERTRecord() {
    }

    @Override
    Record getObject() {
        return new CERTRecord();
    }

    public CERTRecord(Name name, int dclass, long ttl, int certType, int keyTag, int alg, byte[] cert) {
        super(name, 37, dclass, ttl);
        this.certType = CERTRecord.checkU16("certType", certType);
        this.keyTag = CERTRecord.checkU16("keyTag", keyTag);
        this.alg = CERTRecord.checkU8("alg", alg);
        this.cert = cert;
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        this.certType = in.readU16();
        this.keyTag = in.readU16();
        this.alg = in.readU8();
        this.cert = in.readByteArray();
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        String certTypeString = st.getString();
        this.certType = CertificateType.value(certTypeString);
        if (this.certType < 0) {
            throw st.exception("Invalid certificate type: " + certTypeString);
        }
        this.keyTag = st.getUInt16();
        String algString = st.getString();
        this.alg = DNSSEC.Algorithm.value(algString);
        if (this.alg < 0) {
            throw st.exception("Invalid algorithm: " + algString);
        }
        this.cert = st.getBase64();
    }

    @Override
    String rrToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.certType);
        sb.append(" ");
        sb.append(this.keyTag);
        sb.append(" ");
        sb.append(this.alg);
        if (this.cert != null) {
            if (Options.check("multiline")) {
                sb.append(" (\n");
                sb.append(base64.formatString(this.cert, 64, "\t", true));
            } else {
                sb.append(" ");
                sb.append(base64.toString(this.cert));
            }
        }
        return sb.toString();
    }

    public int getCertType() {
        return this.certType;
    }

    public int getKeyTag() {
        return this.keyTag;
    }

    public int getAlgorithm() {
        return this.alg;
    }

    public byte[] getCert() {
        return this.cert;
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeU16(this.certType);
        out.writeU16(this.keyTag);
        out.writeU8(this.alg);
        out.writeByteArray(this.cert);
    }

    public static class CertificateType {
        public static final int PKIX = 1;
        public static final int SPKI = 2;
        public static final int PGP = 3;
        public static final int IPKIX = 4;
        public static final int ISPKI = 5;
        public static final int IPGP = 6;
        public static final int ACPKIX = 7;
        public static final int IACPKIX = 8;
        public static final int URI = 253;
        public static final int OID = 254;
        private static final Mnemonic types = new Mnemonic("Certificate type", 2);

        private CertificateType() {
        }

        public static String string(int type) {
            return types.getText(type);
        }

        public static int value(String s) {
            return types.getValue(s);
        }

        static {
            types.setMaximum(65535);
            types.setNumericAllowed(true);
            types.add(1, "PKIX");
            types.add(2, "SPKI");
            types.add(3, "PGP");
            types.add(1, "IPKIX");
            types.add(2, "ISPKI");
            types.add(3, "IPGP");
            types.add(3, "ACPKIX");
            types.add(3, "IACPKIX");
            types.add(253, "URI");
            types.add(254, "OID");
        }
    }
}

