/*
 * Decompiled with CFR 0.152.
 */
package io.milton.dns.record;

import io.milton.dns.Name;
import io.milton.dns.record.Compression;
import io.milton.dns.record.DNSInput;
import io.milton.dns.record.DNSOutput;
import io.milton.dns.record.Record;
import io.milton.dns.record.Tokenizer;
import java.io.IOException;

public class SRVRecord
extends Record {
    private static final long serialVersionUID = -3886460132387522052L;
    private int priority;
    private int weight;
    private int port;
    private Name target;

    SRVRecord() {
    }

    @Override
    Record getObject() {
        return new SRVRecord();
    }

    public SRVRecord(Name name, int dclass, long ttl, int priority, int weight, int port, Name target) {
        super(name, 33, dclass, ttl);
        this.priority = SRVRecord.checkU16("priority", priority);
        this.weight = SRVRecord.checkU16("weight", weight);
        this.port = SRVRecord.checkU16("port", port);
        this.target = SRVRecord.checkName("target", target);
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        this.priority = in.readU16();
        this.weight = in.readU16();
        this.port = in.readU16();
        this.target = new Name(in);
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.priority = st.getUInt16();
        this.weight = st.getUInt16();
        this.port = st.getUInt16();
        this.target = st.getName(origin);
    }

    @Override
    String rrToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.priority).append(" ");
        sb.append(this.weight).append(" ");
        sb.append(this.port).append(" ");
        sb.append(this.target);
        return sb.toString();
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getPort() {
        return this.port;
    }

    public Name getTarget() {
        return this.target;
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeU16(this.priority);
        out.writeU16(this.weight);
        out.writeU16(this.port);
        this.target.toWire(out, null, canonical);
    }

    @Override
    public Name getAdditionalName() {
        return this.target;
    }
}

