/*
 * Decompiled with CFR 0.152.
 */
package io.milton.dns.tools;

import io.milton.dns.Name;
import io.milton.dns.TextParseException;
import io.milton.dns.record.DClass;
import io.milton.dns.record.Message;
import io.milton.dns.record.Rcode;
import io.milton.dns.record.Record;
import io.milton.dns.record.Resolver;
import io.milton.dns.record.SOARecord;
import io.milton.dns.record.Section;
import io.milton.dns.record.SimpleResolver;
import io.milton.dns.record.TSIG;
import io.milton.dns.record.TTL;
import io.milton.dns.record.Tokenizer;
import io.milton.dns.record.Type;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.net.SocketException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class update {
    Message query;
    Message response;
    Resolver res;
    String server = null;
    Name zone = Name.root;
    long defaultTTL;
    int defaultClass = 1;
    PrintStream log = null;

    void print(Object o) {
        System.out.println(o);
        if (this.log != null) {
            this.log.println(o);
        }
    }

    public Message newMessage() {
        Message msg = new Message();
        msg.getHeader().setOpcode(5);
        return msg;
    }

    public update(InputStream in) throws IOException {
        LinkedList<BufferedReader> inputs = new LinkedList<BufferedReader>();
        LinkedList<InputStream> istreams = new LinkedList<InputStream>();
        this.query = this.newMessage();
        InputStreamReader isr = new InputStreamReader(in);
        BufferedReader br = new BufferedReader(isr);
        inputs.add(br);
        istreams.add(in);
        block64: while (true) {
            try {
                while (true) {
                    String operation;
                    Tokenizer st;
                    Tokenizer.Token token;
                    String line = null;
                    do {
                        InputStream is = (InputStream)istreams.get(0);
                        br = (BufferedReader)inputs.get(0);
                        if (is == System.in) {
                            System.out.print("> ");
                        }
                        if ((line = br.readLine()) != null) continue;
                        br.close();
                        inputs.remove(0);
                        istreams.remove(0);
                        if (!inputs.isEmpty()) continue;
                        return;
                    } while (line == null);
                    if (this.log != null) {
                        this.log.println("> " + line);
                    }
                    if (line.length() == 0 || line.charAt(0) == '#') continue;
                    if (line.charAt(0) == '>') {
                        line = line.substring(1);
                    }
                    if ((token = (st = new Tokenizer(line)).get()).isEOL()) continue;
                    switch (operation = token.value) {
                        case "server": {
                            this.server = st.getString();
                            this.res = new SimpleResolver(this.server);
                            token = st.get();
                            if (!token.isString()) continue block64;
                            String portstr = token.value;
                            this.res.setPort(Short.parseShort(portstr));
                            continue block64;
                        }
                        case "key": {
                            String keyname = st.getString();
                            String keydata = st.getString();
                            if (this.res == null) {
                                this.res = new SimpleResolver(this.server);
                            }
                            this.res.setTSIGKey(new TSIG(keyname, keydata));
                            continue block64;
                        }
                        case "edns": {
                            if (this.res == null) {
                                this.res = new SimpleResolver(this.server);
                            }
                            this.res.setEDNS(st.getUInt16());
                            continue block64;
                        }
                        case "port": {
                            if (this.res == null) {
                                this.res = new SimpleResolver(this.server);
                            }
                            this.res.setPort(st.getUInt16());
                            continue block64;
                        }
                        case "tcp": {
                            if (this.res == null) {
                                this.res = new SimpleResolver(this.server);
                            }
                            this.res.setTCP(true);
                            continue block64;
                        }
                        case "class": {
                            String classStr = st.getString();
                            int newClass = DClass.value(classStr);
                            if (newClass > 0) {
                                this.defaultClass = newClass;
                                continue block64;
                            }
                            this.print("Invalid class " + classStr);
                            continue block64;
                        }
                        case "ttl": {
                            this.defaultTTL = st.getTTL();
                            continue block64;
                        }
                        case "origin": 
                        case "zone": {
                            this.zone = st.getName(Name.root);
                            continue block64;
                        }
                        case "require": {
                            this.doRequire(st);
                            continue block64;
                        }
                        case "prohibit": {
                            this.doProhibit(st);
                            continue block64;
                        }
                        case "add": {
                            this.doAdd(st);
                            continue block64;
                        }
                        case "delete": {
                            this.doDelete(st);
                            continue block64;
                        }
                        case "glue": {
                            this.doGlue(st);
                            continue block64;
                        }
                        case "help": 
                        case "?": {
                            token = st.get();
                            if (token.isString()) {
                                update.help(token.value);
                                continue block64;
                            }
                            update.help(null);
                            continue block64;
                        }
                        case "echo": {
                            this.print(line == null ? "" : line.substring(4).trim());
                            continue block64;
                        }
                        case "send": {
                            this.sendUpdate();
                            this.query = this.newMessage();
                            continue block64;
                        }
                        case "show": {
                            this.print(this.query);
                            continue block64;
                        }
                        case "clear": {
                            this.query = this.newMessage();
                            continue block64;
                        }
                        case "query": {
                            this.doQuery(st);
                            continue block64;
                        }
                        case "quit": 
                        case "q": {
                            if (this.log != null) {
                                this.log.close();
                            }
                            for (Object e : inputs) {
                                BufferedReader tbr = (BufferedReader)e;
                                tbr.close();
                            }
                            System.exit(0);
                        }
                        case "file": {
                            this.doFile(st, inputs, istreams);
                            continue block64;
                        }
                        case "log": {
                            this.doLog(st);
                            continue block64;
                        }
                        case "assert": {
                            if (this.doAssert(st)) continue block64;
                            return;
                        }
                        case "sleep": {
                            long interval = st.getUInt32();
                            try {
                                Thread.sleep(interval);
                            }
                            catch (InterruptedException tbr) {}
                            continue block64;
                        }
                        case "date": {
                            Date now = new Date();
                            token = st.get();
                            if (token.isString() && token.value.equals("-ms")) {
                                this.print(Long.toString(now.getTime()));
                                continue block64;
                            }
                            this.print(now);
                            continue block64;
                        }
                    }
                    this.print("invalid keyword: " + operation);
                }
            }
            catch (TextParseException tpe) {
                System.out.println(tpe.getMessage());
                continue;
            }
            catch (InterruptedIOException iioe) {
                System.out.println("Operation timed out");
                continue;
            }
            catch (SocketException se) {
                System.out.println("Socket error");
                continue;
            }
            catch (IOException ioe) {
                System.out.println(ioe);
                continue;
            }
            break;
        }
    }

    void sendUpdate() throws IOException {
        if (this.query.getHeader().getCount(2) == 0) {
            this.print("Empty update message.  Ignoring.");
            return;
        }
        if (this.query.getHeader().getCount(0) == 0) {
            Name updzone = this.zone;
            int dclass = this.defaultClass;
            if (updzone == null) {
                Record[] recs;
                for (Record rec : recs = this.query.getSectionArray(2)) {
                    if (updzone == null) {
                        updzone = new Name(rec.getName(), 1);
                    }
                    if (rec.getDClass() == 254 || rec.getDClass() == 255) continue;
                    dclass = rec.getDClass();
                    break;
                }
            }
            Record soa = Record.newRecord(updzone, 6, dclass);
            this.query.addRecord(soa, 0);
        }
        if (this.res == null) {
            this.res = new SimpleResolver(this.server);
        }
        this.response = this.res.send(this.query);
        this.print(this.response);
    }

    Record parseRR(Tokenizer st, int classValue, long TTLValue) throws IOException {
        int type;
        long ttl;
        Name name = st.getName(this.zone);
        String s = st.getString();
        try {
            ttl = TTL.parseTTL(s);
            s = st.getString();
        }
        catch (NumberFormatException e) {
            ttl = TTLValue;
        }
        if (DClass.value(s) >= 0) {
            classValue = DClass.value(s);
            s = st.getString();
        }
        if ((type = Type.value(s)) < 0) {
            throw new IOException("Invalid type: " + s);
        }
        Record record = Record.fromString(name, type, classValue, ttl, st, this.zone);
        if (record != null) {
            return record;
        }
        throw new IOException("Parse error");
    }

    void doRequire(Tokenizer st) throws IOException {
        Record record;
        Name name = st.getName(this.zone);
        Tokenizer.Token token = st.get();
        if (token.isString()) {
            int type = Type.value(token.value);
            if (type < 0) {
                throw new IOException("Invalid type: " + token.value);
            }
            token = st.get();
            boolean iseol = token.isEOL();
            st.unget();
            record = !iseol ? Record.fromString(name, type, this.defaultClass, 0L, st, this.zone) : Record.newRecord(name, type, 255, 0L);
        } else {
            record = Record.newRecord(name, 255, 255, 0L);
        }
        this.query.addRecord(record, 1);
        this.print(record);
    }

    void doProhibit(Tokenizer st) throws IOException {
        int type;
        Name name = st.getName(this.zone);
        Tokenizer.Token token = st.get();
        if (token.isString()) {
            type = Type.value(token.value);
            if (type < 0) {
                throw new IOException("Invalid type: " + token.value);
            }
        } else {
            type = 255;
        }
        Record record = Record.newRecord(name, type, 254, 0L);
        this.query.addRecord(record, 1);
        this.print(record);
    }

    void doAdd(Tokenizer st) throws IOException {
        Record record = this.parseRR(st, this.defaultClass, this.defaultTTL);
        this.query.addRecord(record, 2);
        this.print(record);
    }

    void doDelete(Tokenizer st) throws IOException {
        Record record;
        Name name = st.getName(this.zone);
        Tokenizer.Token token = st.get();
        if (token.isString()) {
            int type;
            String s = token.value;
            if (DClass.value(s) >= 0) {
                s = st.getString();
            }
            if ((type = Type.value(s)) < 0) {
                throw new IOException("Invalid type: " + s);
            }
            token = st.get();
            boolean iseol = token.isEOL();
            st.unget();
            record = !iseol ? Record.fromString(name, type, 254, 0L, st, this.zone) : Record.newRecord(name, type, 255, 0L);
        } else {
            record = Record.newRecord(name, 255, 255, 0L);
        }
        this.query.addRecord(record, 2);
        this.print(record);
    }

    void doGlue(Tokenizer st) throws IOException {
        Record record = this.parseRR(st, this.defaultClass, this.defaultTTL);
        this.query.addRecord(record, 3);
        this.print(record);
    }

    void doQuery(Tokenizer st) throws IOException {
        Name name = null;
        int type = 1;
        int dclass = this.defaultClass;
        name = st.getName(this.zone);
        Tokenizer.Token token = st.get();
        if (token.isString()) {
            type = Type.value(token.value);
            if (type < 0) {
                throw new IOException("Invalid type");
            }
            token = st.get();
            if (token.isString() && (dclass = DClass.value(token.value)) < 0) {
                throw new IOException("Invalid class");
            }
        }
        Record rec = Record.newRecord(name, type, dclass);
        Message newQuery = Message.newQuery(rec);
        if (this.res == null) {
            this.res = new SimpleResolver(this.server);
        }
        this.response = this.res.send(newQuery);
        this.print(this.response);
    }

    void doFile(Tokenizer st, List inputs, List istreams) throws IOException {
        String s = st.getString();
        try {
            InputStream is = s.equals("-") ? System.in : new FileInputStream(s);
            istreams.add(0, is);
            inputs.add(0, new BufferedReader(new InputStreamReader(is)));
        }
        catch (FileNotFoundException e) {
            this.print(s + " not found");
        }
    }

    void doLog(Tokenizer st) throws IOException {
        String s = st.getString();
        try {
            FileOutputStream fos = new FileOutputStream(s);
            this.log = new PrintStream(fos);
        }
        catch (Exception e) {
            this.print("Error opening " + s);
        }
    }

    boolean doAssert(Tokenizer st) throws IOException {
        String field = st.getString();
        String expected = st.getString();
        String value = null;
        boolean flag = true;
        if (this.response == null) {
            this.print("No response has been received");
            return true;
        }
        if (field.equalsIgnoreCase("rcode")) {
            int rcode = this.response.getHeader().getRcode();
            if (rcode != Rcode.value(expected)) {
                value = Rcode.string(rcode);
                flag = false;
            }
        } else if (field.equalsIgnoreCase("serial")) {
            Record[] answers = this.response.getSectionArray(1);
            if (answers.length < 1 || !(answers[0] instanceof SOARecord)) {
                this.print("Invalid response (no SOA)");
            } else {
                SOARecord soa = (SOARecord)answers[0];
                long serial = soa.getSerial();
                if (serial != Long.parseLong(expected)) {
                    value = Long.toString(serial);
                    flag = false;
                }
            }
        } else if (field.equalsIgnoreCase("tsig")) {
            value = this.response.isSigned() ? (this.response.isVerified() ? "ok" : "failed") : "unsigned";
            if (!value.equalsIgnoreCase(expected)) {
                flag = false;
            }
        } else {
            int section = Section.value(field);
            if (section >= 0) {
                int count = this.response.getHeader().getCount(section);
                if (count != Integer.parseInt(expected)) {
                    value = Integer.toString(count);
                    flag = false;
                }
            } else {
                this.print("Invalid assertion keyword: " + field);
            }
        }
        if (!flag) {
            Tokenizer.Token token;
            this.print("Expected " + field + " " + expected + ", received " + value);
            while ((token = st.get()).isString()) {
                this.print(token.value);
            }
            st.unget();
        }
        return flag;
    }

    static void help(String topic) {
        System.out.println();
        if (topic == null) {
            System.out.println("The following are supported commands:\nadd      assert   class    clear    date     delete\necho     edns     file     glue     help     key\nlog      port     prohibit query    quit     require\nsend     server   show     sleep    tcp      ttl\nzone     #\n");
            return;
        }
        switch (topic = topic.toLowerCase()) {
            case "add": {
                System.out.println("add <name> [ttl] [class] <type> <data>\n\nspecify a record to be added\n");
                break;
            }
            case "assert": {
                System.out.println("assert <field> <value> [msg]\n\nasserts that the value of the field in the last\nresponse matches the value specified.  If not,\nthe message is printed (if present) and the\nprogram exits.  The field may be any of <rcode>,\n<serial>, <tsig>, <qu>, <an>, <au>, or <ad>.\n");
                break;
            }
            case "class": {
                System.out.println("class <class>\n\nclass of the zone to be updated (default: IN)\n");
                break;
            }
            case "clear": {
                System.out.println("clear\n\nclears the current update packet\n");
                break;
            }
            case "date": {
                System.out.println("date [-ms]\n\nprints the current date and time in human readable\nformat or as the number of milliseconds since the\nepoch");
                break;
            }
            case "delete": {
                System.out.println("delete <name> [ttl] [class] <type> <data> \ndelete <name> <type> \ndelete <name>\n\nspecify a record or set to be deleted, or that\nall records at a name should be deleted\n");
                break;
            }
            case "echo": {
                System.out.println("echo <text>\n\nprints the text\n");
                break;
            }
            case "edns": {
                System.out.println("edns <level>\n\nEDNS level specified when sending messages\n");
                break;
            }
            case "file": {
                System.out.println("file <file>\n\nopens the specified file as the new input source\n(- represents stdin)\n");
                break;
            }
            case "glue": {
                System.out.println("glue <name> [ttl] [class] <type> <data>\n\nspecify an additional record\n");
                break;
            }
            case "help": {
                System.out.println("help\nhelp [topic]\n\nprints a list of commands or help about a specific\ncommand\n");
                break;
            }
            case "key": {
                System.out.println("key <name> <data>\n\nTSIG key used to sign messages\n");
                break;
            }
            case "log": {
                System.out.println("log <file>\n\nopens the specified file and uses it to log output\n");
                break;
            }
            case "port": {
                System.out.println("port <port>\n\nUDP/TCP port messages are sent to (default: 53)\n");
                break;
            }
            case "prohibit": {
                System.out.println("prohibit <name> <type> \nprohibit <name>\n\nrequire that a set or name is not present\n");
                break;
            }
            case "query": {
                System.out.println("query <name> [type [class]] \n\nissues a query\n");
                break;
            }
            case "q": 
            case "quit": {
                System.out.println("quit\n\nquits the program\n");
                break;
            }
            case "require": {
                System.out.println("require <name> [ttl] [class] <type> <data> \nrequire <name> <type> \nrequire <name>\n\nrequire that a record, set, or name is present\n");
                break;
            }
            case "send": {
                System.out.println("send\n\nsends and resets the current update packet\n");
                break;
            }
            case "server": {
                System.out.println("server <name> [port]\n\nserver that receives send updates/queries\n");
                break;
            }
            case "show": {
                System.out.println("show\n\nshows the current update packet\n");
                break;
            }
            case "sleep": {
                System.out.println("sleep <milliseconds>\n\npause for interval before next command\n");
                break;
            }
            case "tcp": {
                System.out.println("tcp\n\nTCP should be used to send all messages\n");
                break;
            }
            case "ttl": {
                System.out.println("ttl <ttl>\n\ndefault ttl of added records (default: 0)\n");
                break;
            }
            case "zone": 
            case "origin": {
                System.out.println("zone <zone>\n\nzone to update (default: .\n");
                break;
            }
            case "#": {
                System.out.println("# <text>\n\na comment\n");
                break;
            }
            default: {
                System.out.println("Topic '" + topic + "' unrecognized\n");
            }
        }
    }

    public static void main(String[] args) throws IOException {
        InputStream in = null;
        if (args.length >= 1) {
            try {
                in = new FileInputStream(args[0]);
            }
            catch (FileNotFoundException e) {
                System.out.println(args[0] + " not found.");
                System.exit(1);
            }
        } else {
            in = System.in;
        }
        update u = new update(in);
    }
}

