/*
 * Decompiled with CFR 0.152.
 */
package io.milton.dns.utils;

import io.milton.dns.Address;
import io.milton.dns.Name;
import io.milton.dns.TextParseException;
import io.milton.dns.record.AAAARecord;
import io.milton.dns.record.ARecord;
import io.milton.dns.record.MXRecord;
import io.milton.dns.record.NSRecord;
import io.milton.dns.record.Record;
import io.milton.dns.record.SOARecord;
import io.milton.dns.resource.ADomainResourceRecord;
import io.milton.dns.resource.DomainResourceRecord;
import io.milton.dns.resource.MXDomainResourceRecord;
import io.milton.dns.resource.NSDomainResourceRecord;
import io.milton.dns.resource.SOADomainResourceRecord;
import io.milton.dns.utils.Utils;
import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RecordTypes {
    private final Map<Class<? extends DomainResourceRecord>, RecordMapper> mappers = new ConcurrentHashMap<Class<? extends DomainResourceRecord>, RecordMapper>();

    public RecordTypes() {
        this.mappers.put(ADomainResourceRecord.class, new ARecordMapper());
        this.mappers.put(MXDomainResourceRecord.class, new MXRecordMapper());
        this.mappers.put(NSDomainResourceRecord.class, new NSRecordMapper());
        this.mappers.put(SOADomainResourceRecord.class, new SOARecordMapper());
    }

    public Record map(Name domainName, DomainResourceRecord r) throws TextParseException {
        RecordMapper mapper = this.get(r);
        if (mapper != null) {
            return mapper.map(domainName, r);
        }
        return null;
    }

    private RecordMapper get(DomainResourceRecord r) {
        Class<?> c = r.getClass();
        for (Map.Entry<Class<? extends DomainResourceRecord>, RecordMapper> entry : this.mappers.entrySet()) {
            if (!entry.getKey().isAssignableFrom(c)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static class SOARecordMapper
    implements RecordMapper<SOADomainResourceRecord> {
        @Override
        public Record map(Name domainName, SOADomainResourceRecord r) throws TextParseException {
            Name thisName = Utils.stringToName(r.getName());
            Name hostName = Utils.stringToName(r.getHost());
            String adminEmail = r.getAdminEmail();
            if (adminEmail != null && adminEmail.contains("@")) {
                adminEmail = adminEmail.replace("@", ".");
            }
            Name adminEmailName = Utils.stringToName(adminEmail);
            return new SOARecord(thisName, 1, r.getTtl(), hostName, adminEmailName, r.getZoneSerialNumber(), r.getRefresh(), r.getRetry(), r.getExpire(), r.getMinimum());
        }
    }

    public static class NSRecordMapper
    implements RecordMapper<NSDomainResourceRecord> {
        @Override
        public Record map(Name domainName, NSDomainResourceRecord r) throws TextParseException {
            Name thisName = Utils.stringToName(r.getName());
            Name targetName = Utils.stringToName(r.getTarget());
            return new NSRecord(thisName, 1, r.getTtl(), targetName);
        }
    }

    public static class MXRecordMapper
    implements RecordMapper<MXDomainResourceRecord> {
        @Override
        public Record map(Name domainName, MXDomainResourceRecord r) throws TextParseException {
            Name thisName = Utils.stringToName(r.getName());
            if (thisName == null) {
                throw new RuntimeException("resource name is null: " + r.getClass() + " - " + r.getName());
            }
            Name targetName = Utils.stringToName(r.getTarget());
            if (targetName == null) {
                throw new RuntimeException("targetName name is null: " + r.getClass() + " - " + r.getTarget());
            }
            return new MXRecord(thisName, 1, r.getTtl(), r.getPriority(), targetName);
        }
    }

    public static class ARecordMapper
    implements RecordMapper<ADomainResourceRecord> {
        @Override
        public Record map(Name domainName, ADomainResourceRecord r) throws TextParseException {
            Record arr;
            Name name = Utils.stringToName(r.getName());
            InetAddress add = r.getAddress();
            if (Address.familyOf(add) == 1) {
                arr = new ARecord(name, 1, r.getTtl(), add);
            } else if (Address.familyOf(add) == 1) {
                arr = new AAAARecord(name, 1, r.getTtl(), add);
            } else {
                throw new RuntimeException("Unknown address type: " + add.getCanonicalHostName());
            }
            return arr;
        }
    }

    public static interface RecordMapper<T extends DomainResourceRecord> {
        public Record map(Name var1, T var2) throws TextParseException;
    }
}

