/*
 * Decompiled with CFR 0.152.
 */
package io.milton.grizzly;

import io.milton.servlet.FileItemWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.util.FileItemHeadersImpl;
import org.apache.commons.lang.StringUtils;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.ReadHandler;
import org.glassfish.grizzly.http.io.NIOInputStream;
import org.glassfish.grizzly.http.io.NIOReader;
import org.glassfish.grizzly.http.multipart.ContentDisposition;
import org.glassfish.grizzly.http.multipart.MultipartEntry;
import org.glassfish.grizzly.http.multipart.MultipartEntryHandler;
import org.glassfish.grizzly.http.multipart.MultipartScanner;
import org.glassfish.grizzly.http.server.Request;

public class MiltonGrizzlyMultipartUploader {
    private final Map<String, String> params;
    private final Map<String, io.milton.http.FileItem> files;
    private final FileItemFactory fileItemFactory;

    public MiltonGrizzlyMultipartUploader(Map<String, String> params, Map<String, io.milton.http.FileItem> files, FileItemFactory fileItemFactory) {
        this.params = params;
        this.files = files;
        this.fileItemFactory = fileItemFactory;
    }

    public void parseRequest(final Request request) throws Throwable {
        AsyncResult ar = AsyncRunnable.wait(new AsyncRunnable<AsyncResult>(){

            @Override
            public void run(final AtomicReference<AsyncResult> notifier) {
                MultipartScanner.scan((Request)request, (MultipartEntryHandler)new MiltonMultipartEntryHandler(MiltonGrizzlyMultipartUploader.this.params, MiltonGrizzlyMultipartUploader.this.files, MiltonGrizzlyMultipartUploader.this.fileItemFactory, notifier), (CompletionHandler)new EmptyCompletionHandler<Request>(){

                    public void cancelled() {
                        this.finish(notifier, new AsyncResult(null));
                    }

                    public void completed(Request result) {
                        this.finish(notifier, new AsyncResult(null));
                    }

                    public void failed(Throwable throwable) {
                        this.finish(notifier, new AsyncResult(throwable));
                    }
                });
            }
        });
        if (!ar.status) {
            if (ar.error instanceof Exception) {
                throw ar.error;
            }
            throw new Exception(ar.error.getMessage(), ar.error);
        }
    }

    public void parseMultipart(MultipartEntry multipartEntry, final AtomicReference<AsyncResult> notifier) throws Throwable {
        MultipartScanner.scan((MultipartEntry)multipartEntry, (MultipartEntryHandler)new MiltonMultipartEntryHandler(this.params, this.files, this.fileItemFactory, notifier), (CompletionHandler)new EmptyCompletionHandler<MultipartEntry>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void failed(Throwable throwable) {
                AtomicReference atomicReference = notifier;
                synchronized (atomicReference) {
                    notifier.set(new AsyncResult(throwable));
                    notifier.notify();
                }
            }
        });
    }

    private static class AsyncResult {
        final boolean status;
        final Throwable error;

        public AsyncResult(Throwable error) {
            this.status = error == null;
            this.error = error;
        }
    }

    private static abstract class AsyncRunnable<T> {
        private AsyncRunnable() {
        }

        protected abstract void run(AtomicReference<T> var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void finish(AtomicReference<T> notifier, T result) {
            AtomicReference<T> atomicReference = notifier;
            synchronized (atomicReference) {
                notifier.set(result);
                notifier.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <T> T wait(AsyncRunnable<T> runnable) throws InterruptedException {
            AtomicReference notifier = new AtomicReference();
            runnable.run(notifier);
            AtomicReference atomicReference = notifier;
            synchronized (atomicReference) {
                while (notifier.get() == null) {
                    notifier.wait();
                }
            }
            return (T)notifier.get();
        }
    }

    private static class UploadReadHandler
    implements ReadHandler {
        private final NIOInputStream inputStream;
        private final OutputStream outputStream;
        private final Consumer<Throwable> cb;
        private final byte[] buf;

        public UploadReadHandler(NIOInputStream inputStream, OutputStream outputStream, Consumer<Throwable> cb) {
            this.inputStream = inputStream;
            this.outputStream = outputStream;
            this.cb = cb;
            this.buf = new byte[2048];
        }

        public void onDataAvailable() throws Exception {
            this.readAndSaveAvail();
            this.inputStream.notifyAvailable((ReadHandler)this);
        }

        public void onError(Throwable t) {
            this.finish(t);
        }

        public void onAllDataRead() throws Exception {
            this.readAndSaveAvail();
            this.finish(null);
        }

        private void readAndSaveAvail() throws IOException {
            while (this.inputStream.isReady()) {
                int readBytes = this.inputStream.read(this.buf);
                this.outputStream.write(this.buf, 0, readBytes);
            }
        }

        private void finish(Throwable t) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.cb.accept(t);
        }
    }

    private class MiltonMultipartEntryHandler
    implements MultipartEntryHandler {
        private final Map<String, String> params;
        private final Map<String, io.milton.http.FileItem> files;
        private final FileItemFactory fileItemFactory;
        private final AtomicReference<AsyncResult> notifier;
        private int paramCount = 0;
        private int fileCount = 0;

        public MiltonMultipartEntryHandler(Map<String, String> params, Map<String, io.milton.http.FileItem> files, FileItemFactory fileItemFactory, AtomicReference<AsyncResult> notifier) {
            this.params = params;
            this.files = files;
            this.fileItemFactory = fileItemFactory;
            this.notifier = notifier;
        }

        public void handle(MultipartEntry multipartEntry) throws Exception {
            String multipartFileName = null;
            String multipartName = null;
            ContentDisposition contentDisposition = multipartEntry.getContentDisposition();
            if (contentDisposition != null) {
                multipartFileName = contentDisposition.getDispositionParamUnquoted("filename");
                multipartName = contentDisposition.getDispositionParamUnquoted("name");
            }
            if (multipartEntry.isMultipart()) {
                try {
                    MiltonGrizzlyMultipartUploader.this.parseMultipart(multipartEntry, this.notifier);
                }
                catch (Throwable ex) {
                    if (ex instanceof Exception) {
                        throw (Exception)ex;
                    }
                    throw new Exception(ex.getMessage(), ex);
                }
            } else if (StringUtils.isNotBlank((String)multipartFileName)) {
                String itemKey;
                if (StringUtils.isBlank((String)multipartName)) {
                    multipartName = "file_" + this.fileCount++;
                }
                if (this.files.containsKey(itemKey = multipartName)) {
                    int count = 1;
                    while (this.files.containsKey(itemKey + count)) {
                        ++count;
                    }
                    itemKey = itemKey + count;
                }
                FileItem f = this.fileItemFactory.createItem(multipartName, multipartEntry.getContentType(), false, multipartFileName);
                FileItemHeadersImpl headers = new FileItemHeadersImpl();
                f.setHeaders((FileItemHeaders)headers);
                for (String headerName : multipartEntry.getHeaderNames()) {
                    headers.addHeader(headerName, multipartEntry.getHeader(headerName));
                }
                String mpn = itemKey;
                OutputStream outputStream = f.getOutputStream();
                NIOInputStream stream = multipartEntry.getNIOInputStream();
                stream.notifyAvailable((ReadHandler)new UploadReadHandler(stream, outputStream, t -> this.files.put(mpn, new FileItemWrapper(f))));
            } else {
                if (StringUtils.isBlank((String)multipartName)) {
                    multipartName = "param_" + this.paramCount++;
                }
                final String mpn = multipartName;
                final NIOReader nioReader = multipartEntry.getNIOReader();
                nioReader.notifyAvailable(new ReadHandler(){

                    public void onDataAvailable() throws Exception {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onError(Throwable t) {
                        try {
                            nioReader.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        AtomicReference atomicReference = MiltonMultipartEntryHandler.this.notifier;
                        synchronized (atomicReference) {
                            MiltonMultipartEntryHandler.this.notifier.set(new AsyncResult(t));
                            MiltonMultipartEntryHandler.this.notifier.notify();
                        }
                    }

                    public void onAllDataRead() throws Exception {
                        char[] chars = new char[nioReader.readyData()];
                        nioReader.read(chars);
                        String s = new String(chars);
                        MiltonMultipartEntryHandler.this.params.put(mpn, s);
                    }
                });
            }
        }
    }
}

