/*
 * Decompiled with CFR 0.152.
 */
package io.milton.grizzly;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.util.encoders.Base64;

public class SSLTools {
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static Certificate parseCertificate(String certificateText) throws CertificateException {
        return SSLTools.parseCertificate(certificateText.getBytes());
    }

    public static Certificate parseCertificate(byte[] certificateBytes) throws CertificateException {
        if (certificateBytes.length == 0) {
            throw new RuntimeException("Empty certificate");
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream bais = new ByteArrayInputStream(certificateBytes);
        try {
            return cf.generateCertificate(bais);
        }
        catch (CertificateException certificateException) {
            throw new CertificateException("Could not read certificate", certificateException);
        }
    }

    public static X509Certificate parseX509Certificate(String certificateText) throws CertificateException {
        return (X509Certificate)SSLTools.parseCertificate(certificateText);
    }

    public static X509Certificate parseX509Certificate(byte[] certificateBytes) throws CertificateException {
        return (X509Certificate)SSLTools.parseCertificate(certificateBytes);
    }

    public static PrivateKey parsePrivateKey(String privateKeyText) throws GeneralSecurityException, IOException {
        return SSLTools.parsePrivateKey(privateKeyText, null);
    }

    public static PrivateKey parsePrivateKey(String privateKeyText, char[] password) throws GeneralSecurityException, IOException {
        return SSLTools.parsePrivateKey(privateKeyText.getBytes(), password);
    }

    public static PrivateKey parsePrivateKey(byte[] privateKeyBytes) throws GeneralSecurityException, IOException {
        return SSLTools.parsePrivateKey(privateKeyBytes, null);
    }

    /*
     * Exception decompiling
     */
    public static PrivateKey parsePrivateKey(byte[] privateKeyBytes, char[] password) throws IOException, GeneralSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static KeyPair parseKeyPair(String privateKeyText) throws GeneralSecurityException, IOException {
        return SSLTools.parseKeyPair(privateKeyText.getBytes(), null);
    }

    public static KeyPair parseKeyPair(String privateKeyText, String password) throws GeneralSecurityException, IOException {
        return SSLTools.parseKeyPair(privateKeyText.getBytes(), password);
    }

    public static KeyPair parseKeyPair(byte[] privateKeyBytes, String password) throws GeneralSecurityException, IOException {
        KeyPair kp;
        ByteArrayInputStream bais = new ByteArrayInputStream(privateKeyBytes);
        PEMParser pemParser = new PEMParser((Reader)new InputStreamReader(bais));
        Object object = pemParser.readObject();
        pemParser.close();
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        if (object == null) {
            throw new IllegalStateException("PEM parsing failed: missing or invalid data");
        }
        if (object instanceof PKCS8EncryptedPrivateKeyInfo) {
            if (password == null) {
                throw new GeneralSecurityException("passphrase required");
            }
            try {
                PublicKey pub;
                InputDecryptorProvider decryptionProv = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(password.toCharArray());
                PrivateKeyInfo privateKeyInfo = ((PKCS8EncryptedPrivateKeyInfo)object).decryptPrivateKeyInfo(decryptionProv);
                ASN1ObjectIdentifier id = privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm();
                PKCS8EncodedKeySpec p8s = new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded());
                if (id.equals((ASN1Primitive)PKCSObjectIdentifiers.rsaEncryption)) {
                    KeyFactory rfact = KeyFactory.getInstance("RSA");
                    RSAPrivateCrtKey rprv = (RSAPrivateCrtKey)rfact.generatePrivate(p8s);
                    pub = rfact.generatePublic(new RSAPublicKeySpec(rprv.getModulus(), rprv.getPublicExponent()));
                } else if (id.equals((ASN1Primitive)X9ObjectIdentifiers.id_dsa)) {
                    KeyFactory dfact = KeyFactory.getInstance("DSA");
                    DSAPrivateKey dprv = (DSAPrivateKey)dfact.generatePrivate(p8s);
                    BigInteger p = dprv.getParams().getP();
                    BigInteger q = dprv.getParams().getQ();
                    BigInteger g = dprv.getParams().getG();
                    pub = dfact.generatePublic(new DSAPublicKeySpec(g.modPow(dprv.getX(), p), p, q, g));
                } else if (id.equals((ASN1Primitive)X9ObjectIdentifiers.id_ecPublicKey)) {
                    ECPrivateKey eprv = ECPrivateKey.getInstance((Object)privateKeyInfo.parsePrivateKey());
                    byte[] eenc = new SubjectPublicKeyInfo(privateKeyInfo.getPrivateKeyAlgorithm(), eprv.getPublicKey().getOctets()).getEncoded();
                    pub = KeyFactory.getInstance("EC").generatePublic(new X509EncodedKeySpec(eenc));
                } else {
                    throw new GeneralSecurityException("unknown private key OID " + id);
                }
                return new KeyPair(pub, converter.getPrivateKey(privateKeyInfo));
            }
            catch (Exception ex) {
                throw new GeneralSecurityException(ex);
            }
        }
        if (object instanceof PEMEncryptedKeyPair) {
            if (password == null) {
                throw new GeneralSecurityException("passphrase required");
            }
            try {
                PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(password.toCharArray());
                kp = converter.getKeyPair(((PEMEncryptedKeyPair)object).decryptKeyPair(decProv));
            }
            catch (Exception e) {
                throw new GeneralSecurityException("wrong passphrase", e);
            }
        } else if (object instanceof PEMKeyPair) {
            kp = converter.getKeyPair((PEMKeyPair)object);
        } else if (object instanceof PrivateKeyInfo) {
            PrivateKey privKey = converter.getPrivateKey((PrivateKeyInfo)object);
            kp = new KeyPair(null, privKey);
        } else {
            throw new IllegalStateException("PEM parser support missing for: " + object);
        }
        return kp;
    }

    public static PublicKey getPublicKeyFromPrivateKey(byte[] privateKeyBytes, String password) throws IOException, GeneralSecurityException {
        KeyPair keypair = SSLTools.parseKeyPair(privateKeyBytes, password);
        return keypair.getPublic();
    }

    public static RSAPrivateKey parseRSAPrivateKey(String privateKeyText, char[] password) throws GeneralSecurityException, IOException {
        return (RSAPrivateKey)SSLTools.parsePrivateKey(privateKeyText, password);
    }

    public static RSAPrivateKey parseRSAPrivateKey(String privateKeyText) throws GeneralSecurityException, IOException {
        return (RSAPrivateKey)SSLTools.parsePrivateKey(privateKeyText, null);
    }

    public static PublicKey parsePublicKey(String publicKeyPEM) throws IOException {
        return (PublicKey)SSLTools.pemReader(publicKeyPEM);
    }

    public static String getCertificateModulusSHA1(X509Certificate cert) throws NoSuchAlgorithmException {
        PublicKey publicKey = cert.getPublicKey();
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new IllegalArgumentException("Certificate file does not contain an RSA public key but a " + publicKey.getClass().getName());
        }
        RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
        byte[] certModulusData = rsaPublicKey.getModulus().toByteArray();
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        byte[] certID = sha1.digest(certModulusData);
        return SSLTools.toHexString(certID);
    }

    public static String getPrivateKeyModulusSHA1(RSAPrivateKey rsaPrivateKey) {
        byte[] keyModulusData = rsaPrivateKey.getModulus().toByteArray();
        byte[] keyID = DigestUtils.sha1((byte[])keyModulusData);
        return SSLTools.toHexString(keyID);
    }

    public static boolean isCertificateValid(String certificateText, String privateKeyText) throws GeneralSecurityException, IOException {
        return SSLTools.isCertificateValid(certificateText, privateKeyText, null);
    }

    public static boolean isCertificateValid(String certificateText, String privateKeyText, char[] privateKeyPassword) throws GeneralSecurityException, IOException {
        RSAPrivateKey pk = SSLTools.parseRSAPrivateKey(privateKeyText, privateKeyPassword);
        X509Certificate certificate = SSLTools.parseX509Certificate(certificateText);
        return SSLTools.isCertificateValid(certificate, pk);
    }

    public static boolean isCertificateValid(X509Certificate cert, RSAPrivateKey privateKey) throws NoSuchAlgorithmException {
        String certIDinHex = SSLTools.getCertificateModulusSHA1(cert);
        String keyIDinHex = SSLTools.getPrivateKeyModulusSHA1(privateKey);
        return certIDinHex.equalsIgnoreCase(keyIDinHex);
    }

    public static String getDkimDnsTxt(String privateKeyText) throws IOException, GeneralSecurityException {
        StringBuilder sb = new StringBuilder();
        sb.append("v=DKIM1; k=rsa; ");
        String cleanedPem = SSLTools.cleanRSAPrivateKeyPem(privateKeyText);
        PublicKey pk = SSLTools.getPublicKeyFromPrivateKey(cleanedPem.getBytes(), null);
        String key = SSLTools.pemWriter(pk);
        key = key.replace("-----BEGIN PUBLIC KEY-----", "");
        key = key.replace("-----END PUBLIC KEY-----", "");
        key = key.replace("\r", "");
        key = key.replace("\n", "");
        sb.append("p=").append(key);
        return sb.toString();
    }

    public static KeyPair generateKeyPair(int keysize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", (Provider)new BouncyCastleProvider());
        keyGen.initialize(keysize, new SecureRandom());
        return keyGen.generateKeyPair();
    }

    public static String cleanRSAPrivateKeyPem(String privateKeyText) {
        String privatePem = privateKeyText;
        String header = "-----BEGIN RSA PRIVATE KEY-----\n";
        String footer = "-----END RSA PRIVATE KEY-----\n";
        privatePem = privatePem.replace("-----BEGIN RSA PRIVATE KEY-----", "");
        privatePem = privatePem.replace("-----END RSA PRIVATE KEY-----", "");
        privatePem = privatePem.replace("\n", "");
        StringBuilder sb = new StringBuilder();
        sb.append(header);
        for (int index = 0; index < privatePem.length(); index += 64) {
            sb.append(privatePem, index, Math.min(index + 64, privatePem.length())).append("\n");
        }
        sb.append(footer);
        return sb.toString();
    }

    private static PrivateKey generatePrivateKeyByPEM(String privateKey) throws InvalidKeySpecException, NoSuchAlgorithmException {
        String privatePem = privateKey;
        privatePem = privatePem.replace("-----BEGIN RSA PRIVATE KEY-----", "");
        privatePem = privatePem.replace("-----END RSA PRIVATE KEY-----", "");
        privatePem = privatePem.replace("\n", "");
        byte[] encoded = Base64.decode((String)privatePem);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PrivateKey privKey = kf.generatePrivate(keySpec);
        return privKey;
    }

    public static String toHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String pemWriter(Object o) throws IOException {
        StringWriter sw = new StringWriter();
        JcaPEMWriter pw = new JcaPEMWriter((Writer)sw);
        pw.writeObject(o);
        pw.flush();
        return sw.toString();
    }

    public static Object pemReader(String pem) throws IOException {
        StringReader reader = new StringReader(pem);
        PEMParser pr = new PEMParser((Reader)reader);
        return pr.readObject();
    }
}

