/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http;

import io.milton.http.Auth;
import io.milton.http.FileItem;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.GetableResource;
import io.milton.resource.PostableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleResource
implements GetableResource,
PostableResource {
    private static final Logger log = LoggerFactory.getLogger(SimpleResource.class);
    final String name;
    final Date modDate;
    final byte[] content;
    final String contentType;
    final String uniqueId;
    final String realm;
    final Resource secureResource;

    public SimpleResource(String name, Date modDate, byte[] content, String contentType, String uniqueId, String realm) {
        this.name = name;
        this.modDate = modDate;
        this.content = content;
        this.contentType = contentType;
        this.uniqueId = uniqueId;
        this.realm = realm;
        this.secureResource = null;
    }

    public SimpleResource(String name, Date modDate, byte[] content, String contentType, String uniqueId, Resource secureResource) {
        this.name = name;
        this.modDate = modDate;
        this.content = content;
        this.contentType = contentType;
        this.uniqueId = uniqueId;
        this.realm = secureResource.getRealm();
        this.secureResource = secureResource;
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException {
        out.write(this.content);
    }

    public Long getMaxAgeSeconds(Auth auth) {
        return 60L;
    }

    public String getContentType(String accepts) {
        return this.contentType;
    }

    public Long getContentLength() {
        return this.content.length;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getName() {
        return this.name;
    }

    public Object authenticate(String user, String password) {
        if (this.secureResource != null) {
            return this.secureResource.authenticate(user, password);
        }
        return user;
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        if (this.secureResource != null) {
            return this.secureResource.authorise(request, method, auth);
        }
        return true;
    }

    public String getRealm() {
        return this.realm;
    }

    public Date getModifiedDate() {
        return this.modDate;
    }

    public String checkRedirect(Request request) {
        return null;
    }

    public String processForm(Map<String, String> parameters, Map<String, FileItem> files) throws BadRequestException, NotAuthorizedException, ConflictException {
        return null;
    }
}

