/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http;

import io.milton.http.Filter;
import io.milton.http.FilterChain;
import io.milton.http.Handler;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardFilter
implements Filter {
    private final Logger log = LoggerFactory.getLogger(StandardFilter.class);
    public static final String INTERNAL_SERVER_ERROR_HTML = "<html><body><h1>Internal Server Error (500)</h1></body></html>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(FilterChain chain, Request request, Response response) {
        HttpManager manager = chain.getHttpManager();
        try {
            Request.Method method = request.getMethod();
            Handler handler = manager.getMethodHandler(method);
            if (handler == null) {
                this.log.warn("No method handler for: " + method + " Please check that dav level 2 protocol support is enabled");
                manager.getResponseHandler().respondMethodNotImplemented(null, response, request);
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("delegate to method handler: " + handler.getClass().getCanonicalName());
                }
                handler.process(manager, request, response);
                if (response.getEntity() != null) {
                    manager.sendResponseEntity(response);
                } else {
                    this.log.debug("No response entity to send to client for method: " + request.getMethod());
                }
            }
        }
        catch (BadRequestException ex) {
            this.log.warn("BadRequestException: " + ex.getReason(), (Throwable)ex);
            manager.getResponseHandler().respondBadRequest(ex.getResource(), response, request);
        }
        catch (ConflictException ex) {
            this.log.warn("conflictException: ", (Throwable)ex);
            manager.getResponseHandler().respondConflict(ex.getResource(), response, request, INTERNAL_SERVER_ERROR_HTML);
        }
        catch (NotAuthorizedException ex) {
            this.log.warn("NotAuthorizedException", (Throwable)ex);
            if (ex.getRequiredStatusCode() == 403) {
                manager.getResponseHandler().respondForbidden(ex.getResource(), response, request);
            } else {
                manager.getResponseHandler().respondUnauthorised(ex.getResource(), response, request);
            }
        }
        catch (NotFoundException ex) {
            this.log.warn("NotFoundException", (Throwable)ex);
            manager.getResponseHandler().respondNotFound(response, request);
        }
        catch (Throwable e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            this.log.error("exception sending content", e);
            response.sendError(Response.Status.SC_INTERNAL_SERVER_ERROR, INTERNAL_SERVER_ERROR_HTML);
        }
        finally {
            manager.closeResponse(response);
        }
    }
}

