/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.common.Path;
import io.milton.http.LockInfo;
import io.milton.http.LockTimeout;
import io.milton.http.LockToken;
import io.milton.http.Request;
import io.milton.http.annotated.AnnoCalendarResource;
import io.milton.http.annotated.AnnoResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.CommonResource;
import io.milton.http.annotated.LockHolder;
import io.milton.http.annotated.LockNullResource;
import io.milton.http.annotated.ResourceList;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.resource.CollectionResource;
import io.milton.resource.DeletableCollectionResource;
import io.milton.resource.ExtMakeCalendarResource;
import io.milton.resource.LockingCollectionResource;
import io.milton.resource.MakeCollectionableResource;
import io.milton.resource.PutableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnoCollectionResource
extends AnnoResource
implements CollectionResource,
PutableResource,
MakeCollectionableResource,
LockingCollectionResource,
DeletableCollectionResource,
ExtMakeCalendarResource {
    private static final Logger log = LoggerFactory.getLogger(AnnoCollectionResource.class);
    private ResourceList children;
    private ResourceList singlyLoadedChildItems;

    public AnnoCollectionResource(AnnotationResourceFactory outer, Object source, AnnoCollectionResource parent) {
        super(outer, source, parent);
    }

    public Resource child(String childName) throws NotAuthorizedException, BadRequestException {
        if (this.singlyLoadedChildItems != null && this.singlyLoadedChildItems.hasChild(childName)) {
            return this.singlyLoadedChildItems.get(childName);
        }
        if (this.children != null) {
            for (Resource r : this.children) {
                if (!r.getName().equals(childName)) continue;
                return r;
            }
        }
        Object childTriValue = null;
        try {
            childTriValue = this.annoFactory.childOfAnnotationHandler.execute(this, childName);
        }
        catch (NotFoundException ex) {
            log.warn("Failed to lookup child", (Throwable)ex);
        }
        if (childTriValue != null && !childTriValue.equals("NotAttempted")) {
            Resource r;
            r = (AnnoResource)childTriValue;
            if (this.singlyLoadedChildItems == null) {
                this.singlyLoadedChildItems = new ResourceList();
            }
            this.singlyLoadedChildItems.add((CommonResource)r);
            return r;
        }
        for (Resource resource : this.getChildren(true)) {
            if (!resource.getName().equals(childName)) continue;
            return resource;
        }
        return null;
    }

    public List<? extends Resource> getChildren() throws NotAuthorizedException, BadRequestException {
        return this.getResourceList();
    }

    public List<? extends Resource> getChildren(boolean isChildLookup) throws NotAuthorizedException, BadRequestException {
        return this.findChildren(isChildLookup);
    }

    public ResourceList getResourceList() throws NotAuthorizedException, BadRequestException {
        return this.findChildren(false);
    }

    public ResourceList getSubFolders() throws NotAuthorizedException, BadRequestException {
        return this.getResourceList().getDirs();
    }

    public ResourceList getFiles() throws NotAuthorizedException, BadRequestException {
        return this.getResourceList().getFiles();
    }

    protected ResourceList findChildren(boolean isChildLookup) throws NotAuthorizedException, BadRequestException {
        if (this.children == null) {
            this.initChildren(isChildLookup);
        }
        return this.children;
    }

    protected void initChildren(boolean isChildLookup) throws NotAuthorizedException, BadRequestException {
        Set<AnnoResource> set;
        this.children = new ResourceList();
        try {
            set = this.annoFactory.childrenOfAnnotationHandler.execute(this, isChildLookup);
        }
        catch (NotAuthorizedException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.children.addAll(set);
        for (LockHolder holder : this.annoFactory.getTempResourcesForParent(this)) {
            CommonResource cr = this.annoFactory.instantiate(holder, this);
            this.children.add(cr);
        }
        if (this.singlyLoadedChildItems != null) {
            for (CommonResource r : this.singlyLoadedChildItems) {
                this.children.remove(r.getName());
                this.children.add(r);
            }
        }
    }

    public Map<String, CommonResource> getChildrenMap() throws NotAuthorizedException, BadRequestException {
        return this.getResourceList().getMap();
    }

    public Map<String, ResourceList> getChildrenOfType() throws NotAuthorizedException, BadRequestException {
        return this.getResourceList().getOfType();
    }

    public CollectionResource createCollection(String newName) throws NotAuthorizedException, ConflictException, BadRequestException {
        Object newlyCreatedSource = this.annoFactory.makCollectionAnnotationHandler.execute(this, newName);
        AnnoCollectionResource r = new AnnoCollectionResource(this.annoFactory, newlyCreatedSource, this);
        if (this.children != null) {
            this.children.add(r);
        }
        return r;
    }

    public CollectionResource createCalendar(String newName, Map<QName, String> fieldsToSet) throws NotAuthorizedException, ConflictException, BadRequestException {
        Object newlyCreatedSource = this.annoFactory.makeCalendarAnnotationHandler.execute(this, newName, fieldsToSet);
        AnnoCalendarResource r = new AnnoCalendarResource(this.annoFactory, newlyCreatedSource, this);
        if (this.children != null) {
            this.children.add(r);
        }
        return r;
    }

    public Resource createNew(String newName, InputStream inputStream, Long length, String contentType) throws IOException, ConflictException, NotAuthorizedException, BadRequestException {
        Object newChildSource = this.annoFactory.putChildAnnotationHandler.execute(this, newName, inputStream, length, contentType);
        AnnoCollectionResource newRes = new AnnoCollectionResource(this.annoFactory, newChildSource, this);
        if (this.children != null) {
            CommonResource oldRes = this.children.get(newName);
            if (oldRes != null) {
                this.children.remove(oldRes);
            }
            this.children.add(newRes);
        }
        return newRes;
    }

    @Override
    public AnnoCollectionResource getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public LockToken createAndLock(String name, LockTimeout timeout, LockInfo lockInfo) throws NotAuthorizedException {
        LockHolder r = this.annoFactory.createLockHolder(this, name, timeout, lockInfo);
        if (this.children != null) {
            CommonResource cr = this.annoFactory.instantiate(r, this.parent);
            this.children.add(cr);
        }
        return new LockToken(r.getId().toString(), lockInfo, timeout);
    }

    void removeLockHolder(String name) {
        if (this.children != null) {
            this.children.removeIf(r -> r instanceof LockNullResource && r.getName().equals(name));
        }
    }

    public boolean isLockedOutRecursive(Request request) {
        return false;
    }

    public Resource find(String s) throws NotAuthorizedException, BadRequestException {
        Path p = Path.path((String)s);
        return this.findPath(p);
    }

    public Resource findPath(Path p) throws NotAuthorizedException, BadRequestException {
        AnnoCollectionResource r = this;
        for (String segment : p.getParts()) {
            if (segment.equals("..")) {
                if (r instanceof AnnoResource) {
                    AnnoResource ar = r;
                    r = ar.getParent();
                    continue;
                }
                log.warn("Couldnt get parent of resource type: " + r.getClass());
                return null;
            }
            if (segment.equals(".")) continue;
            if (r instanceof CollectionResource) {
                CollectionResource col = r;
                r = col.child(segment);
                continue;
            }
            log.warn("Couldnt find child: " + segment + " of parent: " + r.getName() + " because the parent is not actually a collection");
            return null;
        }
        return r;
    }
}

