/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.ChildrenOf;
import io.milton.http.Request;
import io.milton.http.annotated.AbstractAnnotationHandler;
import io.milton.http.annotated.AnnoCollectionResource;
import io.milton.http.annotated.AnnoResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.ControllerMethod;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ChildrenOfAnnotationHandler
extends AbstractAnnotationHandler {
    public ChildrenOfAnnotationHandler(AnnotationResourceFactory outer) {
        super(outer, ChildrenOf.class, Request.Method.PROPFIND);
    }

    public Set<AnnoResource> execute(AnnoCollectionResource parent, boolean isChildLookup) throws Exception {
        HashSet<AnnoResource> result = new HashSet<AnnoResource>();
        List<ControllerMethod> candidateMethods = this.getMethods(parent.source.getClass());
        HashSet<Class> overrideSourceTypes = new HashSet<Class>();
        for (ControllerMethod cm : candidateMethods) {
            ChildrenOf anno = (ChildrenOf)cm.anno;
            if (!anno.override()) continue;
            overrideSourceTypes.add(cm.sourceType);
        }
        if (overrideSourceTypes.size() > 0) {
            Iterator<ControllerMethod> it = candidateMethods.iterator();
            block4: while (it.hasNext()) {
                Class sourceType = it.next().sourceType;
                for (Class overrideClass : overrideSourceTypes) {
                    if (overrideClass == sourceType || !sourceType.isAssignableFrom(overrideClass)) continue;
                    it.remove();
                    continue block4;
                }
            }
        }
        for (ControllerMethod cm : candidateMethods) {
            try {
                if (!this.lookupPermitted(isChildLookup, cm)) continue;
                Object o = this.invoke(cm, parent, new Object[0]);
                this.annoResourceFactory.createAndAppend(result, o, parent, cm);
            }
            catch (BadRequestException | NotAuthorizedException | NotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private boolean lookupPermitted(boolean childLookup, ControllerMethod cm) {
        ChildrenOf anno = (ChildrenOf)cm.anno;
        if (childLookup) {
            return anno.allowChildLookups();
        }
        return true;
    }
}

