/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated.scheduling;

import io.milton.http.annotated.CTagAnnotationHandler;
import io.milton.http.annotated.scheduling.BaseSchedulingResource;
import io.milton.http.caldav.CalendarSearchService;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.principal.CalDavPrincipal;
import io.milton.resource.CalendarCollection;
import io.milton.resource.PropFindableResource;
import io.milton.resource.Resource;
import java.util.Date;
import java.util.List;

public class SchedulingInboxResource
extends BaseSchedulingResource
implements CalendarCollection,
PropFindableResource {
    public SchedulingInboxResource(CalDavPrincipal principal, CalendarSearchService calendarSearchService, String name) {
        super(principal, calendarSearchService, name);
    }

    public Resource child(String childName) throws NotAuthorizedException, BadRequestException {
        for (Resource resource : this.getChildren()) {
            if (!resource.getName().equals(childName)) continue;
            return resource;
        }
        return null;
    }

    public List<? extends Resource> getChildren() throws NotAuthorizedException, BadRequestException {
        return this.calendarSearchService.findAttendeeResources(this.principal);
    }

    public String getCTag() {
        try {
            String ctag = this.calendarSearchService.findAttendeeResourcesCTag(this.principal);
            if (ctag == null) {
                ctag = CTagAnnotationHandler.deriveCtag(this);
            }
            return ctag;
        }
        catch (BadRequestException | NotAuthorizedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Date getCreateDate() {
        return this.principal.getCreateDate();
    }
}

