/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.entity;

import io.milton.common.ReadingException;
import io.milton.common.StreamUtils;
import io.milton.common.WritingException;
import io.milton.http.Response;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamEntity
implements Response.Entity {
    private static final Logger log = LoggerFactory.getLogger(InputStreamEntity.class);
    private final InputStream inputStream;

    public InputStreamEntity(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Response response, OutputStream outputStream) throws Exception {
        try {
            StreamUtils.readTo((InputStream)this.inputStream, (OutputStream)outputStream);
        }
        catch (ReadingException ex) {
            throw new RuntimeException(ex);
        }
        catch (WritingException ex) {
            log.warn("exception writing, client probably closed connection", (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.inputStream);
        }
        log.trace("finished sending content");
    }
}

