/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.fck;

import io.milton.common.FileUtils;
import io.milton.common.Path;
import io.milton.common.Utils;
import io.milton.http.FileItem;
import io.milton.http.Range;
import io.milton.http.XmlWriter;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.fck.FckCommon;
import io.milton.resource.CollectionResource;
import io.milton.resource.GetableResource;
import io.milton.resource.MakeCollectionableResource;
import io.milton.resource.PutableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FckFileManagerResource
extends FckCommon
implements GetableResource {
    private static final Logger log = LoggerFactory.getLogger(FckFileManagerResource.class);
    public static final Path URL = Path.path((String)"/fck_connector.html");
    public static final String UPLOAD_RESPONSE_TEMPLATE = "<script type=\"text/javascript\">window.parent.CKEDITOR.tools.callFunction( [func], \"[name]\" );</script>";
    private FckPostParams uploadParams;

    public FckFileManagerResource(CollectionResource folder) {
        super(folder, URL);
    }

    public String getUniqueId() {
        return "fckeditor";
    }

    public String processForm(Map<String, String> parameters, Map<String, FileItem> files) throws ConflictException, NotAuthorizedException, BadRequestException {
        this.uploadParams = new FckPostParams(parameters);
        this.uploadParams.processFileUploadCommand(files);
        return null;
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException {
        log.debug("sendContent");
        if (this.uploadParams != null) {
            String s = UPLOAD_RESPONSE_TEMPLATE;
            s = s.replace("[func]", params.get("CKEditorFuncNum"));
            s = s.replace("[code]", this.uploadParams.code + "");
            if (this.uploadParams.message == null) {
                this.uploadParams.message = "";
            }
            s = s.replace("[msg]", this.uploadParams.message);
            if (this.uploadParams.newName == null) {
                this.uploadParams.newName = "";
            }
            s = s.replace("[name]", this.uploadParams.newName);
            out.write(s.getBytes("UTF-8"));
        } else {
            FckGetParams getParams = new FckGetParams(out, params);
            try {
                getParams.process();
            }
            catch (ConflictException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private Resource find(CollectionResource wrappedResource, Path p) throws NotAuthorizedException, BadRequestException {
        CollectionResource r = wrappedResource;
        for (String s : p.getParts()) {
            if (r instanceof CollectionResource) {
                CollectionResource col = r;
                if ((r = col.child(s)) != null) continue;
                log.trace("not found: " + s + " in path: " + p);
                return null;
            }
            log.trace("not a collection: " + r.getName() + " in path: " + p);
            return null;
        }
        return r;
    }

    public String getContentType(String accepts) {
        String s = this.uploadParams != null ? "text/html" : "text/xml; charset=UTF-8";
        return s;
    }

    class FckPostParams
    extends FckParams {
        int code;
        String message;
        String newName;

        FckPostParams(Map<String, String> params) {
            super(params);
        }

        void processFileUploadCommand(Map<String, FileItem> files) throws ConflictException, NotAuthorizedException, BadRequestException {
            block1: {
                Collection<FileItem> col;
                block0: {
                    col = files.values();
                    if (col != null && !col.isEmpty()) break block0;
                    log.debug("no files uploaded");
                    break block1;
                }
                log.debug("files: " + col.size());
                Iterator<FileItem> iterator = col.iterator();
                if (!iterator.hasNext()) break block1;
                FileItem f = iterator.next();
                this.processFileUpload(f);
            }
        }

        private void processFileUpload(FileItem f) throws ConflictException, NotAuthorizedException, BadRequestException {
            String sFolder = (String)this.params.get("CurrentFolder");
            log.info("processFileUpload: sFolder: " + sFolder + " - " + sFolder.length());
            String relFolder = sFolder.substring(1);
            Path p = Path.path((String)relFolder);
            Resource r = FckFileManagerResource.this.find(FckFileManagerResource.this.wrappedResource, p);
            if (r instanceof PutableResource) {
                this.target = (PutableResource)r;
            }
            if (this.target == null) {
                log.warn("No putable folder with that path: " + sFolder);
                throw new ConflictException((Resource)this.target);
            }
            String name = f.getName();
            log.info("processFileUpload: " + name);
            boolean isFirst = true;
            while (this.target.child(name) != null) {
                this.newName = name = FileUtils.incrementFileName((String)name, (boolean)isFirst);
                isFirst = false;
            }
            if (!(this.target instanceof PutableResource)) {
                log.warn("The collection is not putable: " + r.getName() + " - " + r.getClass().getCanonicalName());
                throw new ConflictException(r);
            }
            PutableResource putable = (PutableResource)this.target;
            long size = f.getSize();
            try {
                Resource resource = putable.createNew(name, f.getInputStream(), Long.valueOf(size), null);
            }
            catch (ConflictException ex) {
                throw ex;
            }
            catch (BadRequestException | NotAuthorizedException | IOException ex) {
                throw new RuntimeException(ex);
            }
            try {
                if (this.newName != null) {
                    this.uploadResponseOk(name);
                } else {
                    this.uploadResponseOk();
                }
            }
            catch (Throwable ex) {
                log.error("Exception saving new file", ex);
                this.uploadResponseFailed(ex.getMessage());
            }
        }

        private void uploadResponseOk() {
            this.uploadResponse(0, null);
        }

        private void uploadResponseOk(String newName) {
            this.uploadResponse(201, newName);
        }

        private void uploadResponseFailed(String reason) {
            this.uploadResponse(1, reason);
        }

        private void uploadResponse(int code, String message) {
            this.code = code;
            this.message = message;
        }
    }

    class FckGetParams
    extends FckParams {
        final String command;
        final String resourceType;
        String sFolder;
        final String serverPath;
        final String newFolderName;
        private final XmlWriter writer;
        private final OutputStream out;

        FckGetParams(OutputStream out, Map<String, String> params) {
            super(params);
            this.out = out;
            this.writer = new XmlWriter(out);
            this.command = params.get("Command");
            this.resourceType = params.get("Type");
            this.sFolder = params.get("CurrentFolder");
            this.newFolderName = params.get("NewFolderName");
            if (this.sFolder != null) {
                this.sFolder = this.sFolder.trim();
                if (this.sFolder.length() == 0) {
                    this.sFolder = null;
                }
            }
            this.serverPath = params.get("ServerPath");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void process() throws ConflictException, NotAuthorizedException, BadRequestException {
            String relFolder = this.sFolder.substring(1);
            Path p = Path.path((String)relFolder);
            Resource r = FckFileManagerResource.this.find(FckFileManagerResource.this.wrappedResource, p);
            if (r instanceof CollectionResource) {
                this.target = (CollectionResource)r;
            } else {
                log.warn("not found or not CollectionResource: " + r);
            }
            if (this.target == null) {
                log.warn("No PutableResource with that path: " + this.sFolder);
                throw new BadRequestException("Path not found: " + this.sFolder);
            }
            try {
                switch (this.command) {
                    case "GetFolders": {
                        this.processGetFoldersCommand(false);
                        return;
                    }
                    case "GetFoldersAndFiles": {
                        this.processGetFoldersCommand(true);
                        return;
                    }
                    case "CreateFolder": {
                        this.processCreateFolderCommand();
                        return;
                    }
                    case "FileUpload": {
                        this.processUploadFolderCommand();
                        return;
                    }
                    default: {
                        log.warn("Unknown command: " + this.command);
                        throw new ConflictException((Resource)this.target);
                    }
                }
            }
            finally {
                this.writer.flush();
            }
        }

        void initXml() {
            this.writer().writeXMLHeader();
        }

        void processGetFoldersCommand(boolean includeFiles) throws NotAuthorizedException, BadRequestException {
            String nm;
            this.initXml();
            XmlWriter.Element el = this.writer().begin("Connector");
            el.writeAtt("command", this.command);
            el.writeAtt("resourceType", this.resourceType);
            el.open();
            el = this.writer().begin("CurrentFolder");
            el.writeAtt("path", this.sFolder);
            el.writeAtt("url", this.sFolder);
            el.noContent();
            this.writer().open("Folders");
            this.writer().writeText("\n");
            for (Resource r : this.target.getChildren()) {
                if (!(r instanceof CollectionResource)) continue;
                el = this.writer().begin("Folder");
                nm = Utils.escapeXml((String)r.getName());
                el.writeAtt("name", nm);
                el.noContent();
            }
            this.writer().close("Folders");
            if (includeFiles) {
                this.writer().open("Files");
                this.writer().writeText("\n");
                for (Resource r : this.target.getChildren()) {
                    if (r instanceof CollectionResource) continue;
                    el = this.writer().begin("File");
                    nm = Utils.escapeXml((String)r.getName());
                    el.writeAtt("name", nm);
                    if (r instanceof GetableResource) {
                        GetableResource gr = (GetableResource)r;
                        Long sz = gr.getContentLength();
                        String sSize = sz == null ? "" : sz.toString();
                        el.writeAtt("size", sSize);
                        el.noContent();
                        continue;
                    }
                    el.writeAtt("size", "");
                }
                this.writer().close("Files");
            }
            this.writer().close("Connector");
            this.writer().flush();
        }

        void processCreateFolderCommand() {
            int errNumber;
            log.debug("processCreateFolderCommand: " + this.newFolderName);
            try {
                if (this.target.child(this.newFolderName) != null) {
                    log.debug("has child");
                    errNumber = 101;
                } else {
                    if (!(this.target instanceof MakeCollectionableResource)) {
                        throw new BadRequestException((Resource)this.target, "Folder does not allow creating subfolders");
                    }
                    MakeCollectionableResource mk = (MakeCollectionableResource)this.target;
                    CollectionResource collectionResource = mk.createCollection(this.newFolderName);
                    log.debug("add new child ok");
                    errNumber = 0;
                }
            }
            catch (Throwable e) {
                errNumber = 103;
                log.error("Exception creating new folder: " + this.newFolderName + " in " + this.target.getName(), e);
            }
            this.initXml();
            XmlWriter.Element el = this.writer().begin("Connector");
            el.writeAtt("command", this.command);
            el.writeAtt("resourceType", this.resourceType);
            el.open();
            el = this.writer().begin("CurrentFolder");
            el.writeAtt("path", this.sFolder);
            el.writeAtt("url", this.sFolder);
            el.noContent();
            el = this.writer().begin("Error");
            el.writeAtt("number", "" + errNumber);
            el.noContent();
            this.writer().close("Connector");
            this.writer().flush();
        }

        XmlWriter writer() {
            return this.writer;
        }

        private void processUploadFolderCommand() {
            if (FckFileManagerResource.this.uploadParams == null) {
                throw new NullPointerException("no post for upload command");
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<script type='text/javascript'>\n");
            sb.append("window.parent.frames['frmUpload'].OnUploadCompleted(").append(((FckFileManagerResource)FckFileManagerResource.this).uploadParams.code);
            if (((FckFileManagerResource)FckFileManagerResource.this).uploadParams.message != null) {
                sb.append(",'").append(((FckFileManagerResource)FckFileManagerResource.this).uploadParams.message).append("'");
            }
            sb.append(");\n");
            sb.append("</script>\n");
            String s = sb.toString();
            try {
                this.out.write(s.getBytes("UTF-8"));
                this.out.flush();
            }
            catch (IOException e) {
                log.warn("ioexception writing response to upload", (Throwable)e);
            }
        }
    }

    static abstract class FckParams {
        CollectionResource target;
        final Map<String, String> params;

        FckParams(Map<String, String> params) {
            this.params = params;
        }
    }
}

