/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11;

import io.milton.http.Auth;
import io.milton.http.Response;
import io.milton.http.http11.CacheControlHelper;
import io.milton.resource.GetableResource;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCacheControlHelper
implements CacheControlHelper {
    private static final Logger log = LoggerFactory.getLogger(DefaultCacheControlHelper.class);
    private final boolean usePrivateCache = false;

    @Override
    public void setCacheControl(GetableResource resource, Response response, Auth auth) {
        Long delta = resource.getMaxAgeSeconds(auth);
        if (log.isTraceEnabled()) {
            log.trace("setCacheControl: {} - {}", (Object)delta, resource.getClass());
        }
        if (delta != null && delta > 0L) {
            response.setCacheControlMaxAgeHeader(delta);
        } else {
            response.setCacheControlNoCacheHeader();
        }
    }

    public static Date calcExpiresAt(Date modifiedDate, long deltaSeconds) {
        long deltaMs = deltaSeconds * 1000L;
        long expiresAt = System.currentTimeMillis() + deltaMs;
        return new Date(expiresAt);
    }
}

