/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11;

import io.milton.http.DeleteHelper;
import io.milton.http.DeleteHelperImpl;
import io.milton.http.ExistingEntityHandler;
import io.milton.http.HandlerHelper;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.ResourceHandlerHelper;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.http11.Http11ResponseHandler;
import io.milton.resource.DeletableResource;
import io.milton.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteHandler
implements ExistingEntityHandler {
    private final Logger log = LoggerFactory.getLogger(DeleteHandler.class);
    private final Http11ResponseHandler responseHandler;
    private final ResourceHandlerHelper resourceHandlerHelper;
    private DeleteHelper deleteHelper;

    public DeleteHandler(Http11ResponseHandler responseHandler, ResourceHandlerHelper resourceHandlerHelper, HandlerHelper handlerHelper) {
        this.responseHandler = responseHandler;
        this.resourceHandlerHelper = resourceHandlerHelper;
        this.deleteHelper = new DeleteHelperImpl(handlerHelper);
    }

    @Override
    public String[] getMethods() {
        return new String[]{Request.Method.DELETE.code};
    }

    @Override
    public boolean isCompatible(Resource handler) {
        return handler instanceof DeletableResource;
    }

    @Override
    public void process(HttpManager manager, Request request, Response response) throws NotAuthorizedException, ConflictException, BadRequestException {
        String url = request.getAbsoluteUrl();
        if (url.contains("#")) {
            throw new BadRequestException(null, "Can't delete a resource with a # in the url");
        }
        this.resourceHandlerHelper.process(manager, request, response, this);
    }

    @Override
    public void processResource(HttpManager manager, Request request, Response response, Resource r) throws NotAuthorizedException, ConflictException, BadRequestException {
        if (this.resourceHandlerHelper.isNotCompatible(r, request.getMethod())) {
            this.log.debug("resource not compatible. Resource class: " + r.getClass() + " handler: " + this.getClass());
            this.responseHandler.respondMethodNotImplemented(r, response, request);
            return;
        }
        this.resourceHandlerHelper.processResource(manager, request, response, r, this);
    }

    @Override
    public void processExistingResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException, BadRequestException, ConflictException {
        this.log.debug("DELETE: " + request.getAbsoluteUrl());
        DeletableResource r = (DeletableResource)resource;
        if (this.deleteHelper.isLockedOut(request, (Resource)r)) {
            this.log.info("Could not delete. Is locked");
            this.responseHandler.respondDeleteFailed(request, response, (Resource)r, Response.Status.SC_LOCKED);
            return;
        }
        this.deleteHelper.delete(r, manager.getEventManager());
        this.log.debug("deleted ok");
        this.responseHandler.respondNoContent(resource, response, request);
    }

    public DeleteHelper getDeleteHelper() {
        return this.deleteHelper;
    }

    public void setDeleteHelper(DeleteHelper deleteHelper) {
        this.deleteHelper = deleteHelper;
    }
}

