/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11;

import io.milton.http.Handler;
import io.milton.http.HandlerHelper;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.ResourceHandler;
import io.milton.http.ResourceHandlerHelper;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.http11.Http11ResponseHandler;
import io.milton.resource.Resource;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionsHandler
implements ResourceHandler {
    private static final Logger log = LoggerFactory.getLogger(OptionsHandler.class);
    private final Http11ResponseHandler responseHandler;
    private final HandlerHelper handlerHelper;
    private final ResourceHandlerHelper resourceHandlerHelper;
    private boolean enableAuthorisation;

    public OptionsHandler(Http11ResponseHandler responseHandler, ResourceHandlerHelper resourceHandlerHelper, HandlerHelper handlerHelper, boolean enableAuthorisation) {
        this.responseHandler = responseHandler;
        this.handlerHelper = handlerHelper;
        this.resourceHandlerHelper = resourceHandlerHelper;
        this.enableAuthorisation = false;
        this.enableAuthorisation = enableAuthorisation;
    }

    @Override
    public void process(HttpManager manager, Request request, Response response) throws NotAuthorizedException, ConflictException, BadRequestException {
        this.resourceHandlerHelper.process(manager, request, response, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException, ConflictException, BadRequestException {
        long t = System.currentTimeMillis();
        try {
            if (this.enableAuthorisation && !this.handlerHelper.checkAuthorisation(manager, resource, request)) {
                this.responseHandler.respondUnauthorised(resource, response, request);
                return;
            }
            manager.onProcessResourceStart(request, response, resource);
            List<String> methodsAllowed = this.determineMethodsAllowed(manager, resource);
            this.responseHandler.respondWithOptions(resource, response, request, methodsAllowed);
        }
        finally {
            t = System.currentTimeMillis() - t;
            manager.onProcessResourceFinish(request, response, resource, t);
        }
    }

    @Override
    public String[] getMethods() {
        return new String[]{Request.Method.OPTIONS.code};
    }

    @Override
    public boolean isCompatible(Resource handler) {
        return true;
    }

    private List<String> determineMethodsAllowed(HttpManager manager, Resource res) {
        ArrayList<String> list = new ArrayList<String>();
        for (Handler f : manager.getAllHandlers()) {
            if (!f.isCompatible(res)) continue;
            for (String m : f.getMethods()) {
                Request.Method httpMethod = Request.Method.valueOf((String)m);
                if (this.handlerHelper.isNotCompatible(res, httpMethod)) continue;
                list.add(m);
            }
        }
        return list;
    }

    public boolean isEnableAuthorisation() {
        return this.enableAuthorisation;
    }

    public void setEnableAuthorisation(boolean enableAuthorisation) {
        this.enableAuthorisation = enableAuthorisation;
        if (enableAuthorisation && this.handlerHelper == null) {
            throw new RuntimeException("enableAuthorisation set to true, but no handlerHelper has been provided. You WILL get NullPointerException's");
        }
    }
}

