/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11.auth;

import io.milton.http.AbstractWrappingResponseHandler;
import io.milton.http.Auth;
import io.milton.http.Request;
import io.milton.http.ResourceFactory;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.resource.GetableResource;
import io.milton.resource.Resource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginResponseHandler
extends AbstractWrappingResponseHandler {
    private static final Logger log = LoggerFactory.getLogger(LoginResponseHandler.class);
    public static final String ATT_DISABLE = "auth.disable.html";
    private String loginPage = "/login.html";
    private final ResourceFactory resourceFactory;
    private final LoginPageTypeHandler loginPageTypeHandler;
    private List<String> excludePaths;
    private boolean enabled = true;

    public static void setDisableHtmlResponse(Request r) {
        log.trace("html login response disabled for this request");
        r.getAttributes().put(ATT_DISABLE, Boolean.TRUE);
    }

    public LoginResponseHandler(WebDavResponseHandler wrapped, ResourceFactory resourceFactory, LoginPageTypeHandler loginPageTypeHandler) {
        super(wrapped);
        this.resourceFactory = resourceFactory;
        this.loginPageTypeHandler = loginPageTypeHandler;
    }

    @Override
    public void respondUnauthorised(Resource resource, Response response, Request request) {
        log.info("respondUnauthorised");
        Boolean disabled = (Boolean)request.getAttributes().get(ATT_DISABLE);
        if (disabled == null || !disabled.booleanValue()) {
            if (this.isEnabled() && !this.excluded(request) && this.isGetOrPost(request)) {
                if (this.loginPageTypeHandler.canLogin(resource, request)) {
                    this.attemptRespondLoginPage(request, resource, response);
                    return;
                }
                if (this.loginPageTypeHandler.isAjax(resource, request)) {
                    this.respondJson(request, response, resource);
                    return;
                }
            }
        } else {
            log.trace("html login form has been disabled for this request");
        }
        log.trace("respond with normal 401");
        this.wrapped.respondUnauthorised(resource, response, request);
    }

    private void attemptRespondLoginPage(Request request, Resource resource, Response response) throws RuntimeException {
        Resource rLogin;
        log.trace("attemptRespondLoginPage");
        try {
            rLogin = this.resourceFactory.getResource(request.getHostHeader(), this.loginPage);
        }
        catch (BadRequestException | NotAuthorizedException e) {
            throw new RuntimeException(e);
        }
        if (!(rLogin instanceof GetableResource)) {
            log.info("Couldnt find login resource: " + request.getHostHeader() + this.loginPage + " with resource factory: " + this.resourceFactory.getClass());
            this.wrapped.respondUnauthorised(resource, response, request);
        } else {
            log.trace("respond with 200 to suppress login prompt, using resource: " + rLogin.getName() + " - " + rLogin.getClass());
            try {
                Auth auth = request.getAuthorization();
                if (auth != null && auth.getTag() != null) {
                    request.getAttributes().put("authReason", "notPermitted");
                } else {
                    request.getAttributes().put("authReason", "required");
                }
                response.setStatus(Response.Status.SC_BAD_REQUEST);
                GetableResource gr = (GetableResource)rLogin;
                gr.sendContent(response.getOutputStream(), null, null, gr.getContentType(null));
                response.getOutputStream().flush();
            }
            catch (BadRequestException | NotAuthorizedException | NotFoundException | IOException ex) {
                response.setStatus(Response.Status.SC_INTERNAL_SERVER_ERROR);
                response.close();
                log.error("Exception generating login page", ex);
            }
        }
    }

    public String getLoginPage() {
        return this.loginPage;
    }

    public void setLoginPage(String loginPage) {
        this.loginPage = loginPage;
    }

    public ResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    public List<String> getExcludePaths() {
        return this.excludePaths;
    }

    public void setExcludePaths(List<String> excludePaths) {
        this.excludePaths = excludePaths;
    }

    private boolean excluded(Request request) {
        if (CollectionUtils.isEmpty(this.excludePaths)) {
            return false;
        }
        for (String s : this.excludePaths) {
            if (!request.getAbsolutePath().startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private boolean isGetOrPost(Request request) {
        return request.getMethod().equals((Object)Request.Method.GET) || request.getMethod().equals((Object)Request.Method.POST);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private void respondJson(Request request, Response response, Resource resource) {
        JSONObject json = new JSONObject();
        Boolean loginResult = (Boolean)request.getAttributes().get("loginResult");
        json.accumulate("loginResult", (Object)loginResult);
        Auth auth = request.getAuthorization();
        if (auth != null && auth.getTag() != null) {
            json.accumulate("authReason", (Object)"notPermitted");
        } else {
            json.accumulate("authReason", (Object)"required");
        }
        String userUrl = (String)request.getAttributes().get("userUrl");
        if (userUrl != null) {
            json.accumulate("userUrl", (Object)userUrl);
        }
        response.setStatus(Response.Status.SC_BAD_REQUEST);
        response.setCacheControlNoCacheHeader();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            OutputStreamWriter pw = new OutputStreamWriter((OutputStream)bout, "UTF-8");
            json.write((Writer)pw);
            ((Writer)pw).flush();
            byte[] arr = bout.toByteArray();
            response.setContentLengthHeader(Long.valueOf(arr.length));
            response.getOutputStream().write(arr);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static class ContentTypeLoginPageTypeHandler
    implements LoginPageTypeHandler {
        @Override
        public boolean canLogin(Resource resource, Request request) {
            if (resource instanceof GetableResource) {
                String ctHeader = request.getAcceptHeader();
                GetableResource gr = (GetableResource)resource;
                String ctResource = gr.getContentType("text/html");
                if (ctResource == null) {
                    if (ctHeader != null) {
                        boolean b = ctHeader.contains("html");
                        log.trace("isPage: resource has no content type, depends on requested content type: " + b);
                        return b;
                    }
                    log.trace("isPage: resource has no content type, and no requeted content type, so assume false");
                    return false;
                }
                boolean b = ctResource.contains("html");
                log.trace("isPage: resource has content type. is html? " + b);
                return b;
            }
            log.trace("isPage: resource is not getable");
            return false;
        }

        @Override
        public boolean isAjax(Resource r, Request request) {
            String acceptHeader = request.getAcceptHeader();
            return acceptHeader != null && (acceptHeader.contains("application/json") || acceptHeader.contains("text/javascript"));
        }
    }

    public static interface LoginPageTypeHandler {
        public boolean canLogin(Resource var1, Request var2);

        public boolean isAjax(Resource var1, Request var2);
    }
}

