/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.json;

import io.milton.http.FileItem;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.http.json.JsonResource;
import io.milton.http.json.JsonResourceFactory;
import io.milton.resource.GetableResource;
import io.milton.resource.PostableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class PostJsonResource
extends JsonResource
implements PostableResource {
    private final JsonResourceFactory jsonResourceFactory;
    private final String methodParamName;
    private final String host;
    private final String href;
    private Resource res;

    public PostJsonResource(String host, String href, Resource wrappedResource, String methodParamName, JsonResourceFactory jsonResourceFactory) {
        super(wrappedResource, wrappedResource.getName(), null);
        this.methodParamName = methodParamName;
        this.jsonResourceFactory = jsonResourceFactory;
        this.host = host;
        this.href = href;
    }

    @Override
    public Request.Method applicableMethod() {
        return Request.Method.POST;
    }

    public String processForm(Map<String, String> parameters, Map<String, FileItem> files) throws BadRequestException, NotAuthorizedException, ConflictException {
        String method = parameters.get(this.methodParamName);
        this.res = this.jsonResourceFactory.wrapResource(this.host, (Resource)this, method, this.href);
        if (this.res instanceof PostableResource) {
            PostableResource pr = (PostableResource)this.res;
            return pr.processForm(parameters, files);
        }
        return null;
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException, NotFoundException {
        if (this.res == null) {
            String method = params.get(this.methodParamName);
            this.res = this.jsonResourceFactory.wrapResource(this.host, (Resource)this, method, this.href);
        }
        if (this.res instanceof GetableResource) {
            GetableResource gr = (GetableResource)this.res;
            gr.sendContent(out, range, params, contentType);
        }
    }
}

