/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.quota;

import io.milton.common.Path;
import io.milton.http.Request;
import io.milton.http.quota.StorageChecker;
import io.milton.resource.CollectionResource;
import io.milton.resource.GetableResource;
import io.milton.resource.QuotaResource;
import io.milton.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStorageChecker
implements StorageChecker {
    private static final Logger log = LoggerFactory.getLogger(DefaultStorageChecker.class);

    @Override
    public StorageChecker.StorageErrorReason checkStorageOnReplace(Request request, CollectionResource parent, Resource replaced, String host) {
        if (parent instanceof QuotaResource) {
            QuotaResource qr = (QuotaResource)parent;
            Long llAvail = qr.getQuotaAvailable();
            if (llAvail == null) {
                log.debug("no quota data available");
                return null;
            }
            if (llAvail <= 0L) {
                Long newContentLength = request.getContentLengthHeader();
                if (newContentLength == null) {
                    log.debug("new content length is not available, cant check quota, reject");
                    return StorageChecker.StorageErrorReason.SER_QUOTA_EXCEEDED;
                }
                if (replaced instanceof GetableResource) {
                    GetableResource gr = (GetableResource)replaced;
                    Long existingLength = gr.getContentLength();
                    if (existingLength == null) {
                        log.debug("existing content length cant be determined, cant check quota, reject");
                        return StorageChecker.StorageErrorReason.SER_QUOTA_EXCEEDED;
                    }
                    long diff = existingLength - newContentLength;
                    if (diff > 0L) {
                        return null;
                    }
                    log.debug("new content is larger then existing content, but no quota is available, reject");
                    return StorageChecker.StorageErrorReason.SER_QUOTA_EXCEEDED;
                }
                log.debug("existing content length cant be determined, cant check quota, reject");
                return StorageChecker.StorageErrorReason.SER_QUOTA_EXCEEDED;
            }
            Long newContentLength = request.getContentLengthHeader();
            if (newContentLength == null) {
                log.debug("new content length is not available, cant check quota, allow");
                return null;
            }
            if (replaced instanceof GetableResource) {
                GetableResource gr = (GetableResource)replaced;
                Long existingLength = gr.getContentLength();
                if (existingLength == null) {
                    log.debug("existing content length cant be determined, cant check quota, allow");
                    return null;
                }
                long diff = newContentLength - existingLength;
                if (diff <= llAvail) {
                    return null;
                }
                log.debug("new content is larger then existing content, but no quota is available, reject");
                return StorageChecker.StorageErrorReason.SER_QUOTA_EXCEEDED;
            }
            log.debug("existing content length cant be determined, cant check quota, allow");
            return null;
        }
        return null;
    }

    @Override
    public StorageChecker.StorageErrorReason checkStorageOnAdd(Request request, CollectionResource nearestParent, Path parentPath, String host) {
        if (nearestParent instanceof QuotaResource) {
            QuotaResource qr = (QuotaResource)nearestParent;
            Long llAvail = qr.getQuotaAvailable();
            if (llAvail == null) {
                log.debug("no quota data available");
                return null;
            }
            if (llAvail <= 0L) {
                log.debug("no quota available, reject");
                return StorageChecker.StorageErrorReason.SER_QUOTA_EXCEEDED;
            }
            Long newContentLength = request.getContentLengthHeader();
            if (newContentLength == null) {
                log.debug("new content length is not available, cant check quota, allow");
                return null;
            }
            if (newContentLength < llAvail) {
                return null;
            }
            log.debug("new content length is greater then available storage, reject");
            return StorageChecker.StorageErrorReason.SER_QUOTA_EXCEEDED;
        }
        return null;
    }
}

