/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.webdav;

import io.milton.common.Utils;
import io.milton.http.DeleteHelper;
import io.milton.http.DeleteHelperImpl;
import io.milton.http.ExistingEntityHandler;
import io.milton.http.HandlerHelper;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.ResourceHandlerHelper;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.webdav.Dest;
import io.milton.http.webdav.UserAgentHelper;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.resource.CollectionResource;
import io.milton.resource.CopyableResource;
import io.milton.resource.DeletableResource;
import io.milton.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyHandler
implements ExistingEntityHandler {
    private final Logger log = LoggerFactory.getLogger(CopyHandler.class);
    private final WebDavResponseHandler responseHandler;
    private final HandlerHelper handlerHelper;
    private final ResourceHandlerHelper resourceHandlerHelper;
    private final UserAgentHelper userAgentHelper;
    private final DeleteHelper deleteHelper;
    private boolean deleteExistingBeforeCopy = true;

    public CopyHandler(WebDavResponseHandler responseHandler, HandlerHelper handlerHelper, ResourceHandlerHelper resourceHandlerHelper, UserAgentHelper userAgentHelper) {
        this.userAgentHelper = userAgentHelper;
        this.responseHandler = responseHandler;
        this.handlerHelper = handlerHelper;
        this.resourceHandlerHelper = resourceHandlerHelper;
        this.deleteHelper = new DeleteHelperImpl(handlerHelper);
    }

    @Override
    public String[] getMethods() {
        return new String[]{Request.Method.COPY.code};
    }

    @Override
    public boolean isCompatible(Resource handler) {
        return handler instanceof CopyableResource;
    }

    @Override
    public void processResource(HttpManager manager, Request request, Response response, Resource r) throws NotAuthorizedException, ConflictException, BadRequestException {
        this.resourceHandlerHelper.processResource(manager, request, response, r, this);
    }

    @Override
    public void process(HttpManager httpManager, Request request, Response response) throws ConflictException, NotAuthorizedException, BadRequestException {
        this.resourceHandlerHelper.process(httpManager, request, response, this);
    }

    @Override
    public void processExistingResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException, BadRequestException, ConflictException {
        CopyableResource r = (CopyableResource)resource;
        Dest dest = Utils.getDecodedDestination((String)request.getDestinationHeader());
        Resource rDest = manager.getResourceFactory().getResource(dest.host, dest.url);
        this.log.debug("process: copying from: " + r.getName() + " -> " + dest.url + "/" + dest.name);
        if (rDest == null) {
            this.log.debug("process: destination parent does not exist: " + dest);
            this.responseHandler.respondConflict(resource, response, request, "Destination does not exist: " + dest);
        } else if (!(rDest instanceof CollectionResource)) {
            this.log.debug("process: destination exists but is not a collection");
            this.responseHandler.respondConflict(resource, response, request, "Destination exists but is not a collection: " + dest);
        } else {
            this.log.debug("process: copy resource to: " + rDest.getName());
            Resource fDest = manager.getResourceFactory().getResource(dest.host, dest.url + "/" + dest.name);
            if (this.handlerHelper.isLockedOut(request, fDest)) {
                this.responseHandler.respondLocked(request, response, resource);
                return;
            }
            boolean wasDeleted = false;
            CollectionResource colDest = (CollectionResource)rDest;
            Resource rExisting = colDest.child(dest.name);
            if (rExisting != null) {
                if (!this.canOverwrite(request)) {
                    this.log.info("destination resource exists, and overwrite header is not set. dest name: " + dest.name + " dest folder: " + colDest.getName());
                    this.responseHandler.respondPreconditionFailed(request, response, resource);
                    return;
                }
                if (this.deleteHelper.isLockedOut(request, rExisting)) {
                    this.log.info("destination resource exists, and overwrite header IS set, but destination is locked. dest name: " + dest.name + " dest folder: " + colDest.getName());
                    this.responseHandler.respondPreconditionFailed(request, response, resource);
                    return;
                }
                if (this.deleteExistingBeforeCopy) {
                    if (rExisting instanceof DeletableResource) {
                        this.log.debug("copy destination exists and is deletable, delete it..");
                        DeletableResource dr = (DeletableResource)rExisting;
                        if (!this.handlerHelper.checkAuthorisation(manager, (Resource)dr, request, Request.Method.DELETE, request.getAuthorization())) {
                            this.responseHandler.respondUnauthorised((Resource)colDest, response, request);
                            return;
                        }
                        this.deleteHelper.delete(dr, manager.getEventManager());
                        wasDeleted = true;
                    } else {
                        this.log.warn("copy destination exists and is a collection so must be deleted, but does not implement: " + DeletableResource.class);
                        this.responseHandler.respondConflict(rExisting, response, request, dest.toString());
                        return;
                    }
                }
            }
            if (!this.handlerHelper.checkAuthorisation(manager, (Resource)colDest, request, request.getMethod(), request.getAuthorization())) {
                this.responseHandler.respondUnauthorised((Resource)colDest, response, request);
                return;
            }
            r.copyTo(colDest, dest.name);
            if (wasDeleted) {
                this.responseHandler.respondNoContent(resource, response, request);
            } else {
                this.responseHandler.respondCreated(resource, response, request);
            }
        }
    }

    public void setDeleteExistingBeforeCopy(boolean deleteExistingBeforeCopy) {
        this.deleteExistingBeforeCopy = deleteExistingBeforeCopy;
    }

    public boolean isDeleteExistingBeforeCopy() {
        return this.deleteExistingBeforeCopy;
    }

    private boolean canOverwrite(Request request) {
        boolean bHasOverwriteHeader;
        Boolean ow = request.getOverwriteHeader();
        boolean bl = bHasOverwriteHeader = ow != null && request.getOverwriteHeader() != false;
        if (bHasOverwriteHeader) {
            return true;
        }
        String us = request.getUserAgentHeader();
        if (this.userAgentHelper.isMacFinder(request)) {
            this.log.debug("no overwrite header, but user agent is Finder so permit overwrite");
            return true;
        }
        return false;
    }

    public UserAgentHelper getUserAgentHelper() {
        return this.userAgentHelper;
    }
}

