/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.webdav;

import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.XmlWriter;
import io.milton.http.values.ValueWriters;
import io.milton.http.webdav.PropFindResponse;
import io.milton.http.webdav.PropFindXmlFooter;
import io.milton.http.webdav.PropFindXmlGeneratorHelper;
import io.milton.http.webdav.WebDavProtocol;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropFindXmlGenerator {
    private static final Logger log = LoggerFactory.getLogger(PropFindXmlGenerator.class);
    private final PropFindXmlGeneratorHelper helper;

    public PropFindXmlGenerator(ValueWriters valueWriters) {
        this.helper = new PropFindXmlGeneratorHelper(valueWriters);
    }

    PropFindXmlGenerator(PropFindXmlGeneratorHelper helper) {
        this.helper = helper;
    }

    public void generate(List<PropFindResponse> propFindResponses, OutputStream responseOutput, boolean writeErrorProps, PropFindXmlFooter footerGenerator) {
        Map<String, String> mapOfNamespaces = this.helper.findNameSpaces(propFindResponses);
        XmlWriter writer = new XmlWriter(responseOutput);
        writer.writeXMLHeader();
        writer.open(WebDavProtocol.NS_DAV.getPrefix(), "multistatus" + this.helper.generateNamespaceDeclarations(mapOfNamespaces));
        writer.newLine();
        this.helper.appendResponses(writer, propFindResponses, mapOfNamespaces, writeErrorProps);
        if (footerGenerator != null) {
            footerGenerator.footer(writer);
        }
        writer.close(WebDavProtocol.NS_DAV.getPrefix(), "multistatus");
        writer.flush();
    }

    public void generate(List<PropFindResponse> propFindResponses, OutputStream responseOutput, boolean writeErrorProps) {
        this.generate(propFindResponses, responseOutput, writeErrorProps, null);
    }

    public String generate(List<PropFindResponse> propFindResponses) {
        return this.generate(propFindResponses, null);
    }

    public String generate(List<PropFindResponse> propFindResponses, PropFindXmlFooter footerGenerator) {
        boolean writeErrorProps = true;
        Request req = HttpManager.request();
        if (req != null) {
            writeErrorProps = this.isBriefHeader(req);
        }
        ByteArrayOutputStream responseOutput = new ByteArrayOutputStream();
        this.generate(propFindResponses, (OutputStream)responseOutput, writeErrorProps, footerGenerator);
        Map<String, String> mapOfNamespaces = this.helper.findNameSpaces(propFindResponses);
        ByteArrayOutputStream generatedXml = new ByteArrayOutputStream();
        XmlWriter writer = new XmlWriter((OutputStream)generatedXml);
        writer.writeXMLHeader();
        writer.open(WebDavProtocol.NS_DAV.getPrefix(), "multistatus" + this.helper.generateNamespaceDeclarations(mapOfNamespaces));
        writer.newLine();
        this.helper.appendResponses(writer, propFindResponses, mapOfNamespaces, writeErrorProps);
        if (footerGenerator != null) {
            footerGenerator.footer(writer);
        }
        writer.close(WebDavProtocol.NS_DAV.getPrefix(), "multistatus");
        writer.flush();
        if (log.isTraceEnabled()) {
            log.trace("---- PROPFIND response START: " + HttpManager.request().getAbsolutePath() + " -----");
            log.trace(generatedXml.toString());
            log.trace("---- PROPFIND response END -----");
        }
        try {
            return responseOutput.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean isBriefHeader(Request request) {
        String b = (String)request.getHeaders().get("Brief");
        return "t".equals(b);
    }
}

