/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.webdav;

import io.milton.common.NameSpace;
import io.milton.http.DateUtils;
import io.milton.http.Handler;
import io.milton.http.HandlerHelper;
import io.milton.http.HttpExtension;
import io.milton.http.HttpManager;
import io.milton.http.ResourceHandlerHelper;
import io.milton.http.UrlAdapter;
import io.milton.http.XmlWriter;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.http.http11.CustomPostHandler;
import io.milton.http.http11.ETagGenerator;
import io.milton.http.quota.QuotaDataAccessor;
import io.milton.http.report.QualifiedReport;
import io.milton.http.report.Report;
import io.milton.http.report.ReportHandler;
import io.milton.http.values.SupportedReportSetList;
import io.milton.http.values.ValueWriters;
import io.milton.http.webdav.CopyHandler;
import io.milton.http.webdav.DefaultPropPatchParser;
import io.milton.http.webdav.DisplayNameFormatter;
import io.milton.http.webdav.MkColHandler;
import io.milton.http.webdav.MoveHandler;
import io.milton.http.webdav.PropFindHandler;
import io.milton.http.webdav.PropFindPropertyBuilder;
import io.milton.http.webdav.PropFindRequestFieldParser;
import io.milton.http.webdav.PropPatchHandler;
import io.milton.http.webdav.PropPatchSetter;
import io.milton.http.webdav.PropertyMap;
import io.milton.http.webdav.PropertySourcePatchSetter;
import io.milton.http.webdav.ResourceTypeHelper;
import io.milton.http.webdav.UserAgentHelper;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.property.PropertyAuthoriser;
import io.milton.property.PropertySource;
import io.milton.resource.CollectionResource;
import io.milton.resource.DisplayNameResource;
import io.milton.resource.GetableResource;
import io.milton.resource.PropFindableResource;
import io.milton.resource.PutableResource;
import io.milton.resource.Resource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDavProtocol
implements HttpExtension,
PropertySource {
    private static final Logger log = LoggerFactory.getLogger(WebDavProtocol.class);
    public static final String DAV_URI = "DAV:";
    public static final String DAV_PREFIX = "d";
    public static final NameSpace NS_DAV = new NameSpace("DAV:", "d");
    private final Set<Handler> handlers;
    private final Map<String, Report> reports;
    private final ResourceTypeHelper resourceTypeHelper;
    private final QuotaDataAccessor quotaDataAccessor;
    private final PropertyMap propertyMap;
    private final List<PropertySource> propertySources;
    private final ETagGenerator eTagGenerator;
    private final HandlerHelper handlerHelper;
    private final UserAgentHelper userAgentHelper;
    private final DisplayNameFormatter displayNameFormatter;
    private final MkColHandler mkColHandler;
    private final PropPatchHandler propPatchHandler;
    private List<CustomPostHandler> customPostHandlers;

    public WebDavProtocol(HandlerHelper handlerHelper, ResourceTypeHelper resourceTypeHelper, WebDavResponseHandler responseHandler, List<PropertySource> propertySources, QuotaDataAccessor quotaDataAccessor, PropPatchSetter patchSetter, PropertyAuthoriser propertyAuthoriser, ETagGenerator eTagGenerator, UrlAdapter urlAdapter, ResourceHandlerHelper resourceHandlerHelper, UserAgentHelper userAgentHelper, PropFindRequestFieldParser requestFieldParser, PropFindPropertyBuilder propertyBuilder, DisplayNameFormatter displayNameFormatter, boolean enableTextContentProperty) {
        this.displayNameFormatter = displayNameFormatter;
        this.userAgentHelper = userAgentHelper;
        this.handlerHelper = handlerHelper;
        this.eTagGenerator = eTagGenerator;
        this.handlers = new HashSet<Handler>();
        this.resourceTypeHelper = resourceTypeHelper;
        this.quotaDataAccessor = quotaDataAccessor;
        this.propertyMap = new PropertyMap(NS_DAV.getName());
        this.propertyMap.add(new ContentLengthPropertyWriter());
        this.propertyMap.add(new ContentTypePropertyWriter());
        this.propertyMap.add(new CreationDatePropertyWriter("getcreated"));
        this.propertyMap.add(new CreationDatePropertyWriter("creationdate"));
        this.propertyMap.add(new DisplayNamePropertyWriter());
        this.propertyMap.add(new LastModifiedDatePropertyWriter());
        this.propertyMap.add(new ResourceTypePropertyWriter());
        this.propertyMap.add(new EtagPropertyWriter());
        this.propertyMap.add(new MSIsCollectionPropertyWriter());
        this.propertyMap.add(new MSIsReadOnlyPropertyWriter());
        this.propertyMap.add(new MSNamePropertyWriter());
        log.info("resourceTypeHelper: " + resourceTypeHelper.getClass());
        if (quotaDataAccessor == null) {
            log.info("no quota data");
        } else {
            log.info("quotaDataAccessor: " + quotaDataAccessor.getClass());
            this.propertyMap.add(new QuotaAvailableBytesPropertyWriter());
            this.propertyMap.add(new QuotaUsedBytesPropertyWriter());
        }
        this.propertyMap.add(new SupportedReportSetProperty());
        if (enableTextContentProperty) {
            this.propertyMap.add(new MiltonExtTextContentProperty());
        }
        ValueWriters valueWriters = new ValueWriters();
        if (propertySources == null) {
            propertySources = new ArrayList<PropertySource>();
        }
        log.debug("provided property sources: " + propertySources.size());
        this.propertySources = propertySources;
        log.debug("adding webdav as a property source to: " + this.propertySources.getClass() + " hashCode: " + this.propertySources.hashCode());
        this.addPropertySource(this);
        if (patchSetter == null) {
            log.info("creating default patcheSetter: " + PropertySourcePatchSetter.class);
            patchSetter = new PropertySourcePatchSetter(propertySources, valueWriters);
        }
        PropFindHandler propFindHandler = new PropFindHandler(resourceHandlerHelper, requestFieldParser, responseHandler, propertyBuilder);
        this.handlers.add(propFindHandler);
        this.mkColHandler = new MkColHandler(responseHandler, handlerHelper);
        this.handlers.add(this.mkColHandler);
        this.propPatchHandler = new PropPatchHandler(resourceHandlerHelper, new DefaultPropPatchParser(), patchSetter, responseHandler, propertyAuthoriser);
        this.handlers.add(this.propPatchHandler);
        this.handlers.add(new CopyHandler(responseHandler, handlerHelper, resourceHandlerHelper, userAgentHelper));
        this.handlers.add(new MoveHandler(responseHandler, handlerHelper, resourceHandlerHelper, userAgentHelper));
        this.reports = new HashMap<String, Report>();
        this.handlers.add(new ReportHandler(responseHandler, resourceHandlerHelper, this.reports));
    }

    @Override
    public List<CustomPostHandler> getCustomPostHandlers() {
        return this.customPostHandlers;
    }

    public void setCustomPostHandlers(List<CustomPostHandler> customPostHandlers) {
        this.customPostHandlers = customPostHandlers;
    }

    public List<PropertySource> getPropertySources() {
        return Collections.unmodifiableList(this.propertySources);
    }

    public void addPropertySource(PropertySource ps) {
        this.propertySources.add(ps);
        log.debug("adding property source: " + ps.getClass() + " new size: " + this.propertySources.size());
    }

    public void addReport(Report report) {
        this.reports.put(report.getName(), report);
    }

    @Override
    public Set<Handler> getHandlers() {
        return Collections.unmodifiableSet(this.handlers);
    }

    public Object getProperty(QName name, Resource r) {
        return this.propertyMap.getProperty(name, r);
    }

    public void setProperty(QName name, Object value, Resource r) {
        throw new UnsupportedOperationException("Not supported. Standard webdav properties are not writable");
    }

    public PropertySource.PropertyMetaData getPropertyMetaData(QName name, Resource r) {
        PropertySource.PropertyMetaData propertyMetaData = this.propertyMap.getPropertyMetaData(name, r);
        if (propertyMetaData != null && this.userAgentHelper.isNautilus(HttpManager.request())) {
            String s;
            Object v = this.getProperty(name, r);
            if (v == null) {
                return PropertySource.PropertyMetaData.UNKNOWN;
            }
            if (v instanceof String && (s = (String)v).trim().length() == 0) {
                return PropertySource.PropertyMetaData.UNKNOWN;
            }
        }
        return propertyMetaData;
    }

    public void clearProperty(QName name, Resource r) {
        throw new UnsupportedOperationException("Not supported. Standard webdav properties are not writable");
    }

    public List<QName> getAllPropertyNames(Resource r) {
        return this.propertyMap.getAllPropertyNames(r);
    }

    public DisplayNameFormatter getDisplayNameFormatter() {
        return this.displayNameFormatter;
    }

    protected void sendStringProp(XmlWriter writer, String name, String value) {
        if (value == null) {
            writer.writeProperty(null, name);
        } else {
            writer.writeProperty(null, name, value);
        }
    }

    void sendDateProp(XmlWriter writer, String name, Date date) {
        this.sendStringProp(writer, name, date == null ? null : DateUtils.formatDate((Date)date));
    }

    public HandlerHelper getHandlerHelper() {
        return this.handlerHelper;
    }

    public QuotaDataAccessor getQuotaDataAccessor() {
        return this.quotaDataAccessor;
    }

    public Map<String, Report> getReports() {
        return this.reports;
    }

    public ResourceTypeHelper getResourceTypeHelper() {
        return this.resourceTypeHelper;
    }

    public ETagGenerator geteTagGenerator() {
        return this.eTagGenerator;
    }

    public PropertyMap getPropertyMap() {
        return this.propertyMap;
    }

    public MkColHandler getMkColHandler() {
        return this.mkColHandler;
    }

    public PropPatchHandler getPropPatchHandler() {
        return this.propPatchHandler;
    }

    static class MiltonExtTextContentProperty
    implements PropertyMap.StandardProperty<String> {
        MiltonExtTextContentProperty() {
        }

        @Override
        public String fieldName() {
            return "textcontent";
        }

        @Override
        public String getValue(PropFindableResource res) {
            GetableResource gr;
            String ct;
            if (res instanceof GetableResource && (ct = (gr = (GetableResource)res).getContentType("text")) != null && ct.startsWith("text")) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                try {
                    gr.sendContent((OutputStream)bout, null, Collections.EMPTY_MAP, ct);
                    return bout.toString("UTF-8");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (BadRequestException | NotAuthorizedException | NotFoundException e) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public Class getValueClass() {
            return String.class;
        }
    }

    class SupportedReportSetProperty
    implements PropertyMap.StandardProperty<SupportedReportSetList> {
        SupportedReportSetProperty() {
        }

        @Override
        public String fieldName() {
            return "supported-report-set";
        }

        @Override
        public SupportedReportSetList getValue(PropFindableResource res) {
            SupportedReportSetList reportSet = new SupportedReportSetList();
            for (Report report : WebDavProtocol.this.reports.values()) {
                if (report instanceof QualifiedReport) {
                    reportSet.add((Object)((QualifiedReport)report).getQualifiedName());
                    continue;
                }
                reportSet.add((Object)new QName(WebDavProtocol.DAV_URI, report.getName()));
            }
            return reportSet;
        }

        @Override
        public Class getValueClass() {
            return SupportedReportSetList.class;
        }
    }

    static class MSIsReadOnlyPropertyWriter
    implements PropertyMap.StandardProperty<Boolean> {
        MSIsReadOnlyPropertyWriter() {
        }

        @Override
        public String fieldName() {
            return "isreadonly";
        }

        @Override
        public Boolean getValue(PropFindableResource res) {
            return !(res instanceof PutableResource);
        }

        @Override
        public Class getValueClass() {
            return Boolean.class;
        }
    }

    static class MSIsCollectionPropertyWriter
    implements PropertyMap.StandardProperty<Boolean> {
        MSIsCollectionPropertyWriter() {
        }

        @Override
        public String fieldName() {
            return "iscollection";
        }

        @Override
        public Boolean getValue(PropFindableResource res) {
            return res instanceof CollectionResource;
        }

        @Override
        public Class getValueClass() {
            return Boolean.class;
        }
    }

    class MSNamePropertyWriter
    extends DisplayNamePropertyWriter {
        MSNamePropertyWriter() {
        }

        @Override
        public String fieldName() {
            return "name";
        }
    }

    class EtagPropertyWriter
    implements PropertyMap.StandardProperty<String> {
        EtagPropertyWriter() {
        }

        @Override
        public String getValue(PropFindableResource res) {
            return WebDavProtocol.this.eTagGenerator.generateEtag((Resource)res);
        }

        @Override
        public String fieldName() {
            return "getetag";
        }

        @Override
        public Class getValueClass() {
            return String.class;
        }
    }

    class QuotaAvailableBytesPropertyWriter
    implements PropertyMap.StandardProperty<Long> {
        QuotaAvailableBytesPropertyWriter() {
        }

        @Override
        public Long getValue(PropFindableResource res) {
            if (WebDavProtocol.this.quotaDataAccessor != null) {
                return WebDavProtocol.this.quotaDataAccessor.getQuotaAvailable((Resource)res);
            }
            return null;
        }

        @Override
        public String fieldName() {
            return "quota-available-bytes";
        }

        @Override
        public Class getValueClass() {
            return Long.class;
        }
    }

    class QuotaUsedBytesPropertyWriter
    implements PropertyMap.StandardProperty<Long> {
        QuotaUsedBytesPropertyWriter() {
        }

        @Override
        public Long getValue(PropFindableResource res) {
            if (WebDavProtocol.this.quotaDataAccessor != null) {
                return WebDavProtocol.this.quotaDataAccessor.getQuotaUsed((Resource)res);
            }
            return null;
        }

        @Override
        public String fieldName() {
            return "quota-used-bytes";
        }

        @Override
        public Class getValueClass() {
            return Long.class;
        }
    }

    static class ContentLengthPropertyWriter
    implements PropertyMap.StandardProperty<Long> {
        ContentLengthPropertyWriter() {
        }

        @Override
        public Long getValue(PropFindableResource res) {
            if (res instanceof GetableResource) {
                GetableResource getable = (GetableResource)res;
                return getable.getContentLength();
            }
            return null;
        }

        @Override
        public String fieldName() {
            return "getcontentlength";
        }

        @Override
        public Class getValueClass() {
            return Long.class;
        }
    }

    static class ContentTypePropertyWriter
    implements PropertyMap.StandardProperty<String> {
        ContentTypePropertyWriter() {
        }

        @Override
        public String getValue(PropFindableResource res) {
            if (res instanceof GetableResource) {
                GetableResource getable = (GetableResource)res;
                return getable.getContentType(null);
            }
            return "";
        }

        @Override
        public String fieldName() {
            return "getcontenttype";
        }

        @Override
        public Class getValueClass() {
            return String.class;
        }
    }

    class ResourceTypePropertyWriter
    implements PropertyMap.StandardProperty<List<QName>> {
        ResourceTypePropertyWriter() {
        }

        @Override
        public List<QName> getValue(PropFindableResource res) {
            return WebDavProtocol.this.resourceTypeHelper.getResourceTypes((Resource)res);
        }

        @Override
        public String fieldName() {
            return "resourcetype";
        }

        @Override
        public Class getValueClass() {
            return List.class;
        }
    }

    static class LastModifiedDatePropertyWriter
    implements PropertyMap.StandardProperty<Date> {
        LastModifiedDatePropertyWriter() {
        }

        @Override
        public String fieldName() {
            return "getlastmodified";
        }

        @Override
        public Date getValue(PropFindableResource res) {
            return res.getModifiedDate();
        }

        @Override
        public Class<Date> getValueClass() {
            return Date.class;
        }
    }

    static class CreationDatePropertyWriter
    implements PropertyMap.StandardProperty<Date> {
        private final String fieldName;

        public CreationDatePropertyWriter(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public String fieldName() {
            return this.fieldName;
        }

        @Override
        public Date getValue(PropFindableResource res) {
            return res.getCreateDate();
        }

        @Override
        public Class<Date> getValueClass() {
            return Date.class;
        }
    }

    class DisplayNamePropertyWriter
    implements PropertyMap.WritableStandardProperty<String> {
        DisplayNamePropertyWriter() {
        }

        @Override
        public String getValue(PropFindableResource res) {
            if (res instanceof DisplayNameResource) {
                DisplayNameResource dnr = (DisplayNameResource)res;
                return dnr.getDisplayName();
            }
            return WebDavProtocol.this.displayNameFormatter.formatDisplayName(res);
        }

        @Override
        public String fieldName() {
            return "displayname";
        }

        @Override
        public Class<String> getValueClass() {
            return String.class;
        }

        @Override
        public void setValue(PropFindableResource res, String value) {
            if (res instanceof DisplayNameResource) {
                DisplayNameResource dnr = (DisplayNameResource)res;
                dnr.setDisplayName(value);
            } else {
                log.warn("Attempt to set displayname property, but resource is not compatible: " + res.getClass());
            }
        }
    }
}

