/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ldap;

import io.milton.ldap.AttributeCondition;
import io.milton.ldap.Condition;
import io.milton.ldap.LdapPropertyMapper;
import io.milton.ldap.MonoCondition;
import io.milton.ldap.MultiCondition;
import io.milton.ldap.NotCondition;
import java.util.EnumMap;
import java.util.Map;

public class Conditions {
    public final Map<Condition.Operator, String> OPERATOR_MAP = new EnumMap<Condition.Operator, String>(Condition.Operator.class);
    private final LdapPropertyMapper propertyMapper;

    public Conditions(LdapPropertyMapper propertyMapper) {
        this.propertyMapper = propertyMapper;
        this.OPERATOR_MAP.put(Condition.Operator.IsEqualTo, " = ");
        this.OPERATOR_MAP.put(Condition.Operator.IsGreaterThanOrEqualTo, " >= ");
        this.OPERATOR_MAP.put(Condition.Operator.IsGreaterThan, " > ");
        this.OPERATOR_MAP.put(Condition.Operator.IsLessThanOrEqualTo, " <= ");
        this.OPERATOR_MAP.put(Condition.Operator.IsLessThan, " < ");
        this.OPERATOR_MAP.put(Condition.Operator.Like, " like ");
        this.OPERATOR_MAP.put(Condition.Operator.IsNull, " is null");
        this.OPERATOR_MAP.put(Condition.Operator.IsFalse, " = false");
        this.OPERATOR_MAP.put(Condition.Operator.IsTrue, " = true");
        this.OPERATOR_MAP.put(Condition.Operator.StartsWith, " = ");
        this.OPERATOR_MAP.put(Condition.Operator.Contains, " = ");
    }

    public MultiCondition and(Condition ... condition) {
        return new MultiCondition(Condition.Operator.And, condition);
    }

    public MultiCondition or(Condition ... condition) {
        return new MultiCondition(Condition.Operator.Or, condition);
    }

    public Condition not(Condition condition) {
        if (condition == null) {
            return null;
        }
        return new NotCondition(condition);
    }

    public Condition isEqualTo(String attributeName, String value) {
        return new AttributeCondition(this.propertyMapper, attributeName, Condition.Operator.IsEqualTo, value);
    }

    public Condition isEqualTo(String attributeName, int value) {
        return new AttributeCondition(this.propertyMapper, attributeName, Condition.Operator.IsEqualTo, value);
    }

    public Condition gte(String attributeName, String value) {
        return new AttributeCondition(this.propertyMapper, attributeName, Condition.Operator.IsGreaterThanOrEqualTo, value);
    }

    public Condition lte(String attributeName, String value) {
        return new AttributeCondition(this.propertyMapper, attributeName, Condition.Operator.IsLessThanOrEqualTo, value);
    }

    public Condition lt(String attributeName, String value) {
        return new AttributeCondition(this.propertyMapper, attributeName, Condition.Operator.IsLessThan, value);
    }

    public Condition gt(String attributeName, String value) {
        return new AttributeCondition(this.propertyMapper, attributeName, Condition.Operator.IsGreaterThan, value);
    }

    public Condition contains(String attributeName, String value) {
        return new AttributeCondition(this.propertyMapper, attributeName, Condition.Operator.Like, value);
    }

    public Condition startsWith(String attributeName, String value) {
        return new AttributeCondition(this.propertyMapper, attributeName, Condition.Operator.StartsWith, value);
    }

    public Condition isNull(String attributeName) {
        return new MonoCondition(this.propertyMapper, attributeName, Condition.Operator.IsNull);
    }

    public Condition isTrue(String attributeName) {
        return new MonoCondition(this.propertyMapper, attributeName, Condition.Operator.IsTrue);
    }

    public Condition isFalse(String attributeName) {
        return new MonoCondition(this.propertyMapper, attributeName, Condition.Operator.IsFalse);
    }

    protected static enum FolderQueryTraversal {
        Shallow,
        Deep;

    }
}

