/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ldap;

import io.milton.common.LogUtils;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.values.ValueAndType;
import io.milton.http.webdav.PropFindPropertyBuilder;
import io.milton.ldap.SimpleLdapFilter;
import io.milton.resource.PropFindableResource;
import io.milton.resource.Resource;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapPropertyMapper {
    private static final Logger log = LoggerFactory.getLogger(SimpleLdapFilter.class);
    private final PropFindPropertyBuilder propertyBuilder;
    private final Map<QName, String> mapQNameDavToLdap = new ConcurrentHashMap<QName, String>();
    private final Map<String, QName> mapQNameLdapToDav = new ConcurrentHashMap<String, QName>();
    private final Map<String, String> mapLocalNameDavToLdap = new ConcurrentHashMap<String, String>();
    private final Map<String, String> mapLocalNameLdapToDav = new ConcurrentHashMap<String, String>();
    private final String ldapNameSpace = "ldap";

    public LdapPropertyMapper(PropFindPropertyBuilder propertyBuilder) {
        this.propertyBuilder = propertyBuilder;
        this.addLocalNameMapping("name", "uid");
        this.addLocalNameMapping("surName", "surname");
        this.addLocalNameMapping("surName", "sn");
        this.addLocalNameMapping("commonName", "cn");
        this.addLocalNameMapping("country", "c");
        this.addLocalNameMapping("friendlyCountryName", "co");
        this.addLocalNameMapping("givenName", "gn");
        this.addLocalNameMapping("givenName", "givenname");
        this.addLocalNameMapping("organizationName", "o");
        this.addLocalNameMapping("commonName", "nsaimid");
    }

    private void addLocalNameMapping(String davName, String ldapName) {
        this.mapLocalNameDavToLdap.put(davName, ldapName);
        this.mapLocalNameLdapToDav.put(ldapName, davName);
    }

    public ValueAndType getProperty(QName field, Resource resource) throws NotAuthorizedException, BadRequestException {
        return this.propertyBuilder.getProperty(field, resource);
    }

    public QName mapToDavProp(String s) {
        QName q = this.mapQNameLdapToDav.get(s);
        if (q != null) {
            return q;
        }
        String mappedLocalName = this.mapLocalNameLdapToDav.get(s);
        if (mappedLocalName != null) {
            return new QName("ldap", mappedLocalName);
        }
        return new QName("ldap", s);
    }

    public String mapToLdapProp(QName p) {
        String q = this.mapQNameDavToLdap.get(p);
        if (q != null) {
            return q;
        }
        String mappedLocalName = this.mapLocalNameDavToLdap.get(p.getLocalPart());
        if (mappedLocalName != null) {
            return mappedLocalName;
        }
        return p.getLocalPart();
    }

    public String getLdapPropertyValue(String prop, Resource resource) throws BadRequestException {
        ValueAndType vt;
        QName qn = this.mapToDavProp(prop);
        try {
            vt = this.getProperty(qn, resource);
        }
        catch (NotAuthorizedException ex) {
            log.trace("property access not authorised");
            vt = null;
        }
        if (vt != null && vt.getValue() != null) {
            Object propValue = vt.getValue();
            return propValue.toString();
        }
        LogUtils.trace((Logger)log, (Object[])new Object[]{"getLdapPropertyValue: property not found: ldap property: ", prop, " - dav prop: ", qn, "resource: ", resource.getClass()});
        return null;
    }

    public Set<LdapMappedProp> mapProperties(boolean returnAllAttributes, Set<String> returningAttributes, PropFindableResource res) throws NotAuthorizedException, BadRequestException {
        if (returnAllAttributes) {
            Set<QName> davProps = this.propertyBuilder.findAllProps(res);
            HashSet<LdapMappedProp> mapped = new HashSet<LdapMappedProp>();
            for (QName p : davProps) {
                String ldapProp = this.mapToLdapProp(p);
                LdapMappedProp ldapMappedProp = new LdapMappedProp(ldapProp, p);
                mapped.add(ldapMappedProp);
            }
            return mapped;
        }
        HashSet<LdapMappedProp> mapped = new HashSet<LdapMappedProp>();
        for (String s : returningAttributes) {
            QName qn = this.mapToDavProp(s);
            LdapMappedProp ldapMappedProp = new LdapMappedProp(s, qn);
            mapped.add(ldapMappedProp);
        }
        return mapped;
    }

    public static class LdapMappedProp {
        final String ldapName;
        final QName mappedName;

        public LdapMappedProp(String ldapName, QName mappedName) {
            this.ldapName = ldapName;
            this.mappedName = mappedName;
        }
    }
}

