/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ldap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

class LineReaderInputStream
extends PushbackInputStream {
    final String encoding;

    protected LineReaderInputStream(InputStream in, String encoding) {
        super(in);
        this.encoding = encoding == null ? "ASCII" : encoding;
    }

    public String readLine() throws IOException {
        int b;
        ByteArrayOutputStream baos = null;
        while ((b = this.read()) > -1) {
            if (b == 13) {
                int next = this.read();
                if (next == 10) break;
                this.unread(next);
                break;
            }
            if (b == 10) break;
            if (baos == null) {
                baos = new ByteArrayOutputStream();
            }
            baos.write(b);
        }
        if (baos != null) {
            return new String(baos.toByteArray(), this.encoding);
        }
        return null;
    }

    public String readContentAsString(int byteSize) throws IOException {
        return new String(this.readContent(byteSize), this.encoding);
    }

    public byte[] readContent(int byteSize) throws IOException {
        int startIndex;
        byte[] buffer = new byte[byteSize];
        int count = 0;
        for (startIndex = 0; count >= 0 && startIndex < byteSize; startIndex += count) {
            count = this.in.read(buffer, startIndex, byteSize - startIndex);
        }
        if (startIndex < byteSize) {
            throw new RuntimeException("EXCEPTION_END_OF_STREAM");
        }
        return buffer;
    }
}

