/*
 * Decompiled with CFR 0.152.
 */
package io.milton.simpleton;

import io.milton.http.HttpManager;
import io.milton.http.http11.Http11ResponseHandler;
import io.milton.simpleton.SimpleMiltonRequest;
import io.milton.simpleton.SimpleMiltonResponse;
import io.milton.simpleton.Stage;
import io.milton.simpleton.Task;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.core.Container;
import org.simpleframework.transport.connect.Connection;
import org.simpleframework.transport.connect.SocketConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpletonServer
implements Container {
    private static final Logger log = LoggerFactory.getLogger(SimpletonServer.class);
    protected final Stage<Task> dispatchStage;
    private final HttpManager httpManager;
    private final Http11ResponseHandler responseHandler;
    private int httpPort = 80;
    private int sslPort = 0;
    private String certificatesDir;
    private Thread thMonitor;
    private boolean stopped;
    private int maxQueueTimeMillis = 10000;
    private int maxProcessTimeMillis = 60000;
    private Connection connection;

    public SimpletonServer(HttpManager httpManager, Http11ResponseHandler responseHandler, int capacity, int numThreads) {
        this.httpManager = httpManager;
        this.dispatchStage = new Stage("dispatchStage", capacity, numThreads, false);
        this.responseHandler = responseHandler;
        this.thMonitor = new Thread(new TaskMonitor());
    }

    public void start() {
        this.stopped = false;
        try {
            this.connection = new SocketConnection((Container)this);
        }
        catch (Exception ex) {
            throw new RuntimeException("Couldnt create socket connection", ex);
        }
        this.initHttp(this.connection, this.httpPort);
        this.thMonitor = new Thread(new TaskMonitor());
        this.thMonitor.start();
    }

    protected void initHttp(Connection connection, int port) {
        InetSocketAddress address = new InetSocketAddress(port);
        try {
            connection.connect((SocketAddress)address);
        }
        catch (BindException ex) {
            throw new RuntimeException("Couldnt bind to port: " + port);
        }
        catch (Exception ex) {
            throw new RuntimeException("Couldnt start connection", ex);
        }
        log.info("Simpleton server is now running on: " + address);
    }

    public void stop() {
        try {
            this.dispatchStage.close();
        }
        catch (IOException ex) {
            log.error("exception closing dispatchStage", (Throwable)ex);
        }
        this.stopped = true;
        this.thMonitor.interrupt();
        try {
            this.connection.close();
        }
        catch (Exception ex) {
            log.error("exception closing simpleton connection", (Throwable)ex);
        }
    }

    public void handle(Request request, Response response) {
        Task task = new Task(this.httpManager, request, response);
        try {
            this.dispatchStage.enqueue(task);
        }
        catch (Exception e) {
            log.debug("exception dispatching request: " + e.getMessage());
            SimpleMiltonRequest req = new SimpleMiltonRequest(request);
            SimpleMiltonResponse resp = new SimpleMiltonResponse(response);
            this.respondError(req, resp, e.getMessage());
        }
    }

    public void respondError(SimpleMiltonRequest req, SimpleMiltonResponse resp, String reason) {
        this.responseHandler.respondServerError(req, resp, reason);
    }

    private void respondError(Task t) {
        try {
            log.warn("setting error status becaue request could not be processed");
            t.response.setCode(500);
            t.response.close();
        }
        catch (Exception e) {
            log.error("error setting last chance error status", (Throwable)e);
        }
    }

    public Integer getHttpPort() {
        return this.httpPort;
    }

    public int getSslPort() {
        return this.sslPort;
    }

    public void setHttpPort(Integer httpPort) {
        this.httpPort = httpPort;
    }

    public void setSslPort(int sslPort) {
        this.sslPort = sslPort;
    }

    public String getCertificatesDir() {
        return this.certificatesDir;
    }

    public void setCertificatesDir(String certificatesDir) {
        this.certificatesDir = certificatesDir;
    }

    public int getMaxProcessTimeMillis() {
        return this.maxProcessTimeMillis;
    }

    public void setMaxProcessTimeMillis(int maxProcessTimeMillis) {
        this.maxProcessTimeMillis = maxProcessTimeMillis;
    }

    public int getMaxQueueTimeMillis() {
        return this.maxQueueTimeMillis;
    }

    public void setMaxQueueTimeMillis(int maxQueueTimeMillis) {
        this.maxQueueTimeMillis = maxQueueTimeMillis;
    }

    private void checkTasks() {
        for (Task t : this.dispatchStage.queue) {
            long l = System.currentTimeMillis() - t.enqueueTime;
            if (l > (long)this.maxQueueTimeMillis) {
                log.warn("XXX task is too long in queue: " + l + "ms. " + t);
                log.warn("Queue Size: " + this.dispatchStage.queue.size());
                log.warn("listing contents of queue -");
                for (Task q : this.dispatchStage.queue) {
                    log.warn(" - " + q.request.getTarget());
                }
                log.warn("---");
                this.dispatchStage.queue.remove(t);
                this.respondError(t);
                continue;
            }
            if (t.startTime <= 0L || (l = System.currentTimeMillis() - t.startTime) <= (long)this.maxProcessTimeMillis) continue;
            log.warn("**** task is too long being processed: " + l + "ms. " + t);
            t.thisThread.interrupt();
        }
    }

    public class TaskMonitor
    implements Runnable {
        @Override
        public void run() {
            boolean isInterrupted = false;
            while (!SimpletonServer.this.stopped && !isInterrupted) {
                SimpletonServer.this.checkTasks();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    log.debug("interrupted");
                    isInterrupted = true;
                }
            }
        }
    }
}

