/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.maven;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.cumulative.CumulativeCounter;
import io.micrometer.core.instrument.cumulative.CumulativeDistributionSummary;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionCounter;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionTimer;
import io.micrometer.core.instrument.cumulative.CumulativeTimer;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.internal.DefaultGauge;
import io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import io.micrometer.core.instrument.internal.DefaultMeter;
import io.micrometer.core.instrument.util.DoubleFormat;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.Nullable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.maven.plugin.logging.Log;

@NonNullApi
public class MavenLoggingMeterRegistry
extends MeterRegistry {
    private final Log log;

    public MavenLoggingMeterRegistry(Log log) {
        super(Clock.SYSTEM);
        this.log = log;
    }

    public void close() {
        this.getMeters().stream().sorted((m1, m2) -> {
            int typeComp = m1.getId().getType().compareTo((Enum)m2.getId().getType());
            if (typeComp == 0) {
                return m1.getId().getName().compareTo(m2.getId().getName());
            }
            return typeComp;
        }).forEach(m2 -> {
            Printer print = new Printer((Meter)m2);
            m2.use(gauge -> this.log.info((CharSequence)(print.id() + " value=" + print.value(gauge.value()))), counter -> {
                double count = counter.count();
                this.log.info((CharSequence)(print.id() + " count=" + print.count(count)));
            }, timer -> {
                HistogramSnapshot snapshot = timer.takeSnapshot();
                long count = snapshot.count();
                this.log.info((CharSequence)(print.id() + " count=" + print.unitlessCount(count) + " mean=" + print.time(snapshot.mean(this.getBaseTimeUnit())) + " max=" + print.time(snapshot.max(this.getBaseTimeUnit()))));
            }, summary -> {
                HistogramSnapshot snapshot = summary.takeSnapshot();
                long count = snapshot.count();
                this.log.info((CharSequence)(print.id() + " count=" + print.unitlessCount(count) + " mean=" + print.value(snapshot.mean()) + " max=" + print.value(snapshot.max())));
            }, longTaskTimer -> {
                int activeTasks = longTaskTimer.activeTasks();
                this.log.info((CharSequence)(print.id() + " active=" + print.value(activeTasks) + " duration=" + print.time(longTaskTimer.duration(this.getBaseTimeUnit()))));
            }, timeGauge -> {
                double value = timeGauge.value(this.getBaseTimeUnit());
                this.log.info((CharSequence)(print.id() + " value=" + print.time(value)));
            }, counter -> {
                double count = counter.count();
                this.log.info((CharSequence)(print.id() + " count=" + print.count(count)));
            }, timer -> {
                double count = timer.count();
                this.log.info((CharSequence)(print.id() + " count=" + print.count(count) + " mean=" + print.time(timer.mean(this.getBaseTimeUnit()))));
            }, meter -> this.log.info((CharSequence)this.writeMeter((Meter)meter, print)));
        });
    }

    String writeMeter(Meter meter, Printer print) {
        return StreamSupport.stream(meter.measure().spliterator(), false).map(ms -> {
            String msLine = ms.getStatistic().getTagValueRepresentation() + "=";
            switch (ms.getStatistic()) {
                case TOTAL: 
                case MAX: 
                case VALUE: {
                    return msLine + print.value(ms.getValue());
                }
                case TOTAL_TIME: 
                case DURATION: {
                    return msLine + print.time(ms.getValue());
                }
                case COUNT: {
                    return "count=" + print.count(ms.getValue());
                }
            }
            return msLine + DoubleFormat.decimalOrNan((double)ms.getValue());
        }).collect(Collectors.joining(", ", print.id() + " ", ""));
    }

    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        return new CumulativeTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit(), false);
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        return new CumulativeDistributionSummary(id, this.clock, distributionStatisticConfig, scale, false);
    }

    protected Counter newCounter(Meter.Id id) {
        return new CumulativeCounter(id);
    }

    protected <T> Gauge newGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        return new DefaultGauge(id, obj, valueFunction);
    }

    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        return new CumulativeFunctionTimer(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit());
    }

    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        return new CumulativeFunctionCounter(id, obj, countFunction);
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        return new DefaultLongTaskTimer(id, this.clock, this.getBaseTimeUnit(), distributionStatisticConfig, false);
    }

    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return new DefaultMeter(id, type, measurements);
    }

    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(Duration.ofMinutes(1L)).bufferLength(Integer.valueOf(3)).build();
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    class Printer {
        private final Meter meter;

        Printer(Meter meter) {
            this.meter = meter;
        }

        String id() {
            return MavenLoggingMeterRegistry.this.getConventionName(this.meter.getId()) + MavenLoggingMeterRegistry.this.getConventionTags(this.meter.getId()).stream().map(t -> t.getKey() + "=" + t.getValue()).collect(Collectors.joining(",", "{", "}"));
        }

        String count(double count) {
            return this.humanReadableBaseUnit(count);
        }

        String unitlessCount(double count) {
            return DoubleFormat.decimalOrNan((double)count);
        }

        String time(double time) {
            return TimeUtils.format((Duration)Duration.ofNanos((long)TimeUtils.convert((double)time, (TimeUnit)MavenLoggingMeterRegistry.this.getBaseTimeUnit(), (TimeUnit)TimeUnit.NANOSECONDS)));
        }

        String value(double value) {
            return this.humanReadableBaseUnit(value);
        }

        String humanReadableByteCount(double bytes) {
            int unit = 1024;
            if (bytes < (double)unit || Double.isNaN(bytes)) {
                return DoubleFormat.decimalOrNan((double)bytes) + " B";
            }
            int exp = (int)(Math.log(bytes) / Math.log(unit));
            String pre = "KMGTPE".charAt(exp - 1) + "i";
            return DoubleFormat.decimalOrNan((double)(bytes / Math.pow(unit, exp))) + " " + pre + "B";
        }

        String humanReadableBaseUnit(double value) {
            String baseUnit = this.meter.getId().getBaseUnit();
            if ("bytes".equals(baseUnit)) {
                return this.humanReadableByteCount(value);
            }
            return DoubleFormat.decimalOrNan((double)value) + (baseUnit != null ? " " + baseUnit : "");
        }
    }
}

