/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.AutoCloseBase;
import com.github.luben.zstd.EndDirective;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictCompress;
import com.github.luben.zstd.ZstdException;
import com.github.luben.zstd.ZstdFrameProgression;
import com.github.luben.zstd.util.Native;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ZstdCompressCtx
extends AutoCloseBase {
    private long nativePtr = ZstdCompressCtx.init();
    private ZstdDictCompress compression_dict = null;

    private static native long init();

    private static native void free(long var0);

    public ZstdCompressCtx() {
        if (0L == this.nativePtr) {
            throw new IllegalStateException("ZSTD_createCompressCtx failed");
        }
        this.storeFence();
    }

    @Override
    void doClose() {
        if (this.nativePtr != 0L) {
            ZstdCompressCtx.free(this.nativePtr);
            this.nativePtr = 0L;
        }
    }

    private void ensureOpen() {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
    }

    public ZstdCompressCtx setLevel(int n2) {
        this.ensureOpen();
        this.acquireSharedLock();
        ZstdCompressCtx.setLevel0(this.nativePtr, n2);
        this.releaseSharedLock();
        return this;
    }

    private static native void setLevel0(long var0, int var2);

    public ZstdCompressCtx setMagicless(boolean bl) {
        this.ensureOpen();
        this.acquireSharedLock();
        Zstd.setCompressionMagicless(this.nativePtr, bl);
        this.releaseSharedLock();
        return this;
    }

    public ZstdCompressCtx setChecksum(boolean bl) {
        this.ensureOpen();
        this.acquireSharedLock();
        ZstdCompressCtx.setChecksum0(this.nativePtr, bl);
        this.releaseSharedLock();
        return this;
    }

    private static native void setChecksum0(long var0, boolean var2);

    public ZstdCompressCtx setWorkers(int n2) {
        this.ensureOpen();
        this.acquireSharedLock();
        Zstd.setCompressionWorkers(this.nativePtr, n2);
        this.releaseSharedLock();
        return this;
    }

    public ZstdCompressCtx setContentSize(boolean bl) {
        this.ensureOpen();
        this.acquireSharedLock();
        ZstdCompressCtx.setContentSize0(this.nativePtr, bl);
        this.releaseSharedLock();
        return this;
    }

    private static native void setContentSize0(long var0, boolean var2);

    public ZstdCompressCtx setDictID(boolean bl) {
        this.ensureOpen();
        this.acquireSharedLock();
        ZstdCompressCtx.setDictID0(this.nativePtr, bl);
        this.releaseSharedLock();
        return this;
    }

    private static native void setDictID0(long var0, boolean var2);

    public ZstdCompressCtx setLong(int n2) {
        this.ensureOpen();
        this.acquireSharedLock();
        Zstd.setCompressionLong(this.nativePtr, n2);
        this.releaseSharedLock();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZstdCompressCtx loadDict(ZstdDictCompress zstdDictCompress) {
        this.ensureOpen();
        this.acquireSharedLock();
        zstdDictCompress.acquireSharedLock();
        try {
            long l2 = this.loadCDictFast0(this.nativePtr, zstdDictCompress);
            if (Zstd.isError(l2)) {
                throw new ZstdException(l2);
            }
            this.compression_dict = zstdDictCompress;
        }
        finally {
            zstdDictCompress.releaseSharedLock();
            this.releaseSharedLock();
        }
        return this;
    }

    private native long loadCDictFast0(long var1, ZstdDictCompress var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZstdCompressCtx loadDict(byte[] byArray) {
        this.ensureOpen();
        this.acquireSharedLock();
        try {
            long l2 = this.loadCDict0(this.nativePtr, byArray);
            if (Zstd.isError(l2)) {
                throw new ZstdException(l2);
            }
            this.compression_dict = null;
        }
        finally {
            this.releaseSharedLock();
        }
        return this;
    }

    private native long loadCDict0(long var1, byte[] var3);

    public ZstdFrameProgression getFrameProgression() {
        this.ensureOpen();
        return ZstdCompressCtx.getFrameProgression0(this.nativePtr);
    }

    private static native ZstdFrameProgression getFrameProgression0(long var0);

    public void reset() {
        this.ensureOpen();
        long l2 = ZstdCompressCtx.reset0(this.nativePtr);
        if (Zstd.isError(l2)) {
            throw new ZstdException(l2);
        }
    }

    private static native long reset0(long var0);

    public void setPledgedSrcSize(long l2) {
        this.ensureOpen();
        long l3 = ZstdCompressCtx.setPledgedSrcSize0(this.nativePtr, l2);
        if (Zstd.isError(l3)) {
            throw new ZstdException(l3);
        }
    }

    private static native long setPledgedSrcSize0(long var0, long var2);

    public boolean compressDirectByteBufferStream(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, EndDirective endDirective) {
        this.ensureOpen();
        long l2 = ZstdCompressCtx.compressDirectByteBufferStream0(this.nativePtr, byteBuffer, byteBuffer.position(), byteBuffer.limit(), byteBuffer2, byteBuffer2.position(), byteBuffer2.limit(), endDirective.value());
        if ((l2 & 0x80000000L) != 0L) {
            long l3 = l2 & 0xFFL;
            throw new ZstdException(l3, Zstd.getErrorName(l3));
        }
        byteBuffer2.position((int)(l2 & Integer.MAX_VALUE));
        byteBuffer.position((int)(l2 >>> 32) & Integer.MAX_VALUE);
        return l2 >>> 63 == 1L;
    }

    private static native long compressDirectByteBufferStream0(long var0, ByteBuffer var2, int var3, int var4, ByteBuffer var5, int var6, int var7, int var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compressDirectByteBuffer(ByteBuffer byteBuffer, int n2, int n3, ByteBuffer byteBuffer2, int n4, int n5) {
        this.ensureOpen();
        if (!byteBuffer2.isDirect()) {
            throw new IllegalArgumentException("srcBuff must be a direct buffer");
        }
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("dstBuff must be a direct buffer");
        }
        this.acquireSharedLock();
        try {
            long l2 = ZstdCompressCtx.compressDirectByteBuffer0(this.nativePtr, byteBuffer, n2, n3, byteBuffer2, n4, n5);
            if (Zstd.isError(l2)) {
                throw new ZstdException(l2);
            }
            if (l2 > Integer.MAX_VALUE) {
                throw new ZstdException(Zstd.errGeneric(), "Output size is greater than MAX_INT");
            }
            int n6 = (int)l2;
            return n6;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static native long compressDirectByteBuffer0(long var0, ByteBuffer var2, int var3, int var4, ByteBuffer var5, int var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compressByteArray(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        this.ensureOpen();
        this.acquireSharedLock();
        try {
            long l2 = ZstdCompressCtx.compressByteArray0(this.nativePtr, byArray, n2, n3, byArray2, n4, n5);
            if (Zstd.isError(l2)) {
                throw new ZstdException(l2);
            }
            if (l2 > Integer.MAX_VALUE) {
                throw new ZstdException(Zstd.errGeneric(), "Output size is greater than MAX_INT");
            }
            int n6 = (int)l2;
            return n6;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static native long compressByteArray0(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6, int var7);

    public int compress(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n2 = this.compressDirectByteBuffer(byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position(), byteBuffer2, byteBuffer2.position(), byteBuffer2.limit() - byteBuffer2.position());
        byteBuffer2.position(byteBuffer2.limit());
        byteBuffer.position(byteBuffer.position() + n2);
        return n2;
    }

    public ByteBuffer compress(ByteBuffer byteBuffer) throws ZstdException {
        long l2 = Zstd.compressBound(byteBuffer.limit() - byteBuffer.position());
        if (l2 > Integer.MAX_VALUE) {
            throw new ZstdException(Zstd.errGeneric(), "Max output size is greater than MAX_INT");
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect((int)l2);
        int n2 = this.compressDirectByteBuffer(byteBuffer2, 0, (int)l2, byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position());
        byteBuffer.position(byteBuffer.limit());
        byteBuffer2.limit(n2);
        return byteBuffer2;
    }

    public int compress(byte[] byArray, byte[] byArray2) {
        return this.compressByteArray(byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public byte[] compress(byte[] byArray) {
        long l2 = Zstd.compressBound(byArray.length);
        if (l2 > Integer.MAX_VALUE) {
            throw new ZstdException(Zstd.errGeneric(), "Max output size is greater than MAX_INT");
        }
        byte[] byArray2 = new byte[(int)l2];
        int n2 = this.compressByteArray(byArray2, 0, byArray2.length, byArray, 0, byArray.length);
        return Arrays.copyOfRange(byArray2, 0, n2);
    }

    static {
        Native.load();
    }
}

