/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.zipkin;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.zipkin.BytesEncoderAdapter;
import io.opentelemetry.exporter.zipkin.LocalInetAddressSupplier;
import io.opentelemetry.exporter.zipkin.OtelToZipkinSpanTransformer;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import java.net.InetAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.reporter.BytesMessageSender;
import zipkin2.reporter.Sender;
import zipkin2.reporter.SpanBytesEncoder;
import zipkin2.reporter.okhttp3.OkHttpSender;

public final class ZipkinSpanExporterBuilder {
    private zipkin2.reporter.BytesEncoder<Span> encoder = SpanBytesEncoder.JSON_V2;
    private Supplier<InetAddress> localIpAddressSupplier = LocalInetAddressSupplier.getInstance();
    @Nullable
    private BytesMessageSender sender;
    private String endpoint = "http://localhost:9411/api/v2/spans";
    private boolean compressionEnabled = true;
    private int readTimeoutMillis = (int)TimeUnit.SECONDS.toMillis(10L);
    private Supplier<MeterProvider> meterProviderSupplier = GlobalOpenTelemetry::getMeterProvider;

    @Deprecated
    public ZipkinSpanExporterBuilder setSender(Sender sender) {
        return this.setSender((BytesMessageSender)sender);
    }

    public ZipkinSpanExporterBuilder setSender(BytesMessageSender sender) {
        Objects.requireNonNull(sender, "sender");
        this.sender = sender;
        return this;
    }

    @Deprecated
    public ZipkinSpanExporterBuilder setEncoder(BytesEncoder<Span> encoder) {
        Objects.requireNonNull(encoder, "encoder");
        return this.setEncoder(new BytesEncoderAdapter(encoder));
    }

    public ZipkinSpanExporterBuilder setEncoder(zipkin2.reporter.BytesEncoder<Span> encoder) {
        Objects.requireNonNull(encoder, "encoder");
        this.encoder = encoder;
        return this;
    }

    public ZipkinSpanExporterBuilder setLocalIpAddressSupplier(Supplier<InetAddress> localIpAddressSupplier) {
        Objects.requireNonNull(localIpAddressSupplier, "localIpAddressSupplier");
        this.localIpAddressSupplier = localIpAddressSupplier;
        return this;
    }

    public ZipkinSpanExporterBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.endpoint = endpoint;
        return this;
    }

    public ZipkinSpanExporterBuilder setCompression(String compressionMethod) {
        Objects.requireNonNull(compressionMethod, "compressionMethod");
        Utils.checkArgument((compressionMethod.equals("gzip") || compressionMethod.equals("none") ? 1 : 0) != 0, (String)"Unsupported compression method. Supported compression methods include: gzip, none.");
        this.compressionEnabled = compressionMethod.equals("gzip");
        return this;
    }

    public ZipkinSpanExporterBuilder setReadTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"timeout must be non-negative");
        long timeoutMillis = timeout == 0L ? Long.MAX_VALUE : unit.toMillis(timeout);
        this.readTimeoutMillis = (int)Math.min(timeoutMillis, Integer.MAX_VALUE);
        return this;
    }

    public ZipkinSpanExporterBuilder setReadTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        this.setReadTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    public ZipkinSpanExporterBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.meterProviderSupplier = () -> meterProvider;
        return this;
    }

    String toString(boolean includePrefixAndSuffix) {
        StringJoiner joiner = includePrefixAndSuffix ? new StringJoiner(", ", "ZipkinSpanExporterBuilder{", "}") : new StringJoiner(", ");
        joiner.add("endpoint=" + this.endpoint);
        joiner.add("compressionEnabled=" + this.compressionEnabled);
        joiner.add("readTimeoutMillis=" + this.readTimeoutMillis);
        return joiner.toString();
    }

    public ZipkinSpanExporter build() {
        BytesMessageSender sender = this.sender;
        if (sender == null) {
            sender = OkHttpSender.newBuilder().endpoint(this.endpoint).compressionEnabled(this.compressionEnabled).readTimeout(this.readTimeoutMillis).build();
        }
        OtelToZipkinSpanTransformer transformer = OtelToZipkinSpanTransformer.create(this.localIpAddressSupplier);
        return new ZipkinSpanExporter(this, this.encoder, sender, this.meterProviderSupplier, transformer);
    }
}

