/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.models.properties.PropertyBuilder;
import io.swagger.util.AllowableEnumValues;
import io.swagger.util.AllowableRangeValues;
import io.swagger.util.AllowableValuesUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AllowableValuesTest {
    @Test(description="parse allowableValues")
    public void allowableValuesTest() {
        AllowableRangeValues inclusiveRange = (AllowableRangeValues)AllowableValuesUtils.create((String)"range[1, 5]");
        Assert.assertEquals((Object)inclusiveRange.getMinimum(), (Object)1.0);
        Assert.assertEquals((Object)inclusiveRange.getMaximum(), (Object)5.0);
        Assert.assertFalse((boolean)inclusiveRange.isExclusiveMinimum());
        Assert.assertFalse((boolean)inclusiveRange.isExclusiveMaximum());
        EnumMap<PropertyBuilder.PropertyId, Object> map = new EnumMap<PropertyBuilder.PropertyId, Object>(PropertyBuilder.PropertyId.class){
            {
                this.put(PropertyBuilder.PropertyId.MINIMUM, 1.0);
                this.put(PropertyBuilder.PropertyId.MAXIMUM, 5.0);
            }
        };
        Assert.assertEquals((Map)inclusiveRange.asPropertyArguments(), (Map)map);
        AllowableRangeValues exclusiveRange = (AllowableRangeValues)AllowableValuesUtils.create((String)"range(1, 5)");
        Assert.assertEquals((Object)exclusiveRange.getMinimum(), (Object)1.0);
        Assert.assertEquals((Object)exclusiveRange.getMaximum(), (Object)5.0);
        Assert.assertTrue((boolean)exclusiveRange.isExclusiveMaximum());
        Assert.assertTrue((boolean)exclusiveRange.isExclusiveMinimum());
        AllowableRangeValues negativeInfinityRange = (AllowableRangeValues)AllowableValuesUtils.create((String)"range[-infinity, 5]");
        Assert.assertNull((Object)negativeInfinityRange.getMinimum());
        Assert.assertEquals((Object)negativeInfinityRange.getMaximum(), (Object)5.0);
        Assert.assertFalse((boolean)negativeInfinityRange.isExclusiveMaximum());
        Assert.assertFalse((boolean)negativeInfinityRange.isExclusiveMinimum());
        AllowableRangeValues positiveInfinityRange = (AllowableRangeValues)AllowableValuesUtils.create((String)"range[1, infinity]");
        Assert.assertEquals((Object)positiveInfinityRange.getMinimum(), (Object)1.0);
        Assert.assertNull((Object)positiveInfinityRange.getMaximum());
        Assert.assertFalse((boolean)positiveInfinityRange.isExclusiveMaximum());
        Assert.assertFalse((boolean)positiveInfinityRange.isExclusiveMinimum());
        AllowableRangeValues mixedRange = (AllowableRangeValues)AllowableValuesUtils.create((String)"range[1.0, 8.0)");
        Assert.assertEquals((Object)mixedRange.getMinimum(), (Object)1.0);
        Assert.assertEquals((Object)mixedRange.getMaximum(), (Object)8.0);
        Assert.assertFalse((boolean)mixedRange.isExclusiveMinimum());
        Assert.assertTrue((boolean)mixedRange.isExclusiveMaximum());
        AllowableEnumValues stringValues = (AllowableEnumValues)AllowableValuesUtils.create((String)"str1, str2");
        Assert.assertEquals((Collection)stringValues.getItems(), Arrays.asList("str1", "str2"));
        EnumMap<PropertyBuilder.PropertyId, Object> stringMap = new EnumMap<PropertyBuilder.PropertyId, Object>(PropertyBuilder.PropertyId.class){
            {
                this.put(PropertyBuilder.PropertyId.ENUM, Arrays.asList("str1", "str2"));
            }
        };
        Assert.assertEquals((Map)stringValues.asPropertyArguments(), (Map)stringMap);
    }
}

